package gov.va.med.ars.controller;

import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import gov.va.med.ars.exceptions.GenericException;
import gov.va.med.ars.model.response.GenericResponse;
import gov.va.med.ars.model.response.UserDetailsResponse;
import gov.va.med.ars.model.response.UserInfoResponse;
import gov.va.med.ars.service.IAuthenticatorService;
import gov.va.med.domain.ars.ArsUser;
import net.minidev.json.JSONObject;


/**
 *  This is a controller that will handle the User Authentication and send Roles of the User
 *
 */

@RestController
@RequestMapping("/api/v1")
public class AuthenticatorController {

	private static final Logger logger = LogManager.getLogger(AuthenticatorController.class);
	
	@Autowired
	IAuthenticatorService authenticatorService;

	/**
	 * This method return the list of UserRoles
	 * @param guid
	 * @return ResponseEntity<List<UserRoles>>
	 * @throws GenericException 
	 */
	
	
	@RequestMapping(value="/roles",method = RequestMethod.GET, produces = "application/json")
	public ResponseEntity<UserInfoResponse> getUserRoles(@RequestParam String guid) throws GenericException {
		logger.info("getUserRoles : "+"getting userroles for "+guid);
		
		try {
			//Authenticate the User First
			boolean isAuthenticated = authenticatorService.authenticate(guid);
			UserInfoResponse userRolesResponse;
			if(isAuthenticated) {
				//Get UserRoles
				userRolesResponse = authenticatorService.getUserRoles();
				if(userRolesResponse != null && !(userRolesResponse.getUserRoles().isEmpty())) {
					return new ResponseEntity<>(userRolesResponse,HttpStatus.OK);
				}
				else {
					logger.warn("getUserRoles : 0 Roles found for "+guid);
					return new ResponseEntity<>(HttpStatus.NOT_FOUND);
				}
			}
			else {
				logger.error("getUserRoles : Authentication failed for GUID: "+guid);
				throw new GenericException("", "", HttpStatus.ACCEPTED);
			}
		} catch(GenericException u) {
			logger.error("getUserRoles : Exception is raised ");
			throw u;
		}
	
	}
	
	
	/**
	 * This method return the list of UserRoles
	 * @param userName
	 * @return ResponseEntity<List<UserRoles>>
	 * @throws GenericException 
	 */
	@RequestMapping(value="/userRoles",method = RequestMethod.GET, produces = "application/json")
	public ResponseEntity<?> authenticateAndgetRoles(@RequestParam String userName) throws GenericException {
		logger.info("authenticateAndgetRoles : "+"getting userroles for "+userName);
		
		try {
			//Authenticate the User First
			boolean isAuthenticated = authenticatorService.authenticateUser(userName);
			UserInfoResponse userRolesResponse;
			JSONObject response = null;
			if(isAuthenticated) {
				//Get UserRoles
				userRolesResponse = authenticatorService.getUserRoles();
				if(userRolesResponse != null && !(userRolesResponse.getUserRoles().isEmpty())) {
					return new ResponseEntity<>(userRolesResponse,HttpStatus.OK);
				}
				else {
					response = new JSONObject();
					logger.warn("getUserRoles : 0 Roles found for "+userName);
					response.put("errorCode", "Un-Authorized");
					response.put("message", "The entered user has no access to the application");
					return new ResponseEntity<>(response,HttpStatus.NOT_FOUND);
				}
			}
			else {
				response = new JSONObject();
				logger.error("getUserRoles : Authentication failed for userName: "+userName);
				response.put("errorCode", "Invalid User");
				response.put("message", "The entered user has no access to the application");
				throw new GenericException("", "", HttpStatus.NOT_FOUND);
			}
		} catch(GenericException u) {
			logger.error("getUserRoles : Exception is raised ");
			throw u;
		}
	
	}
/*
 * returns the list of users with different roles	
 */
	@RequestMapping(value = "/users", method = RequestMethod.GET, produces = "application/json")
	public ResponseEntity<?> getUsers(){
		logger.info("get all users method request recieved ");
		ResponseEntity<?> response = null;
		try{
			List<String> users = authenticatorService.getUsers();
			response = new ResponseEntity<List<String>>(users, HttpStatus.OK);
			logger.info("get all users "+users);
		}
		catch(Exception e){
			logger.error("Error occured getting userroles : " + e.getMessage());
		}
		return response;
	}
	
	/**
	 * This method return the User Details
	 * @param userName
	 * @return ResponseEntity<UserDetailsResponse>
	 * @throws GenericException 
	 */	
	
/*	*//**
	 * Get authentication param's that are required to invoke third party service 
	 * @param request Http servlet request object
	 * @return Authentication parameters (encryptedDefaultUrl, encryptedPostBackUrl, sessionId, aspCheckPageUrl and errorPageUrl)
	 * @throws GenericException
	 *//*
	@RequestMapping(value="/authParams",method = RequestMethod.GET, produces = "application/json")
	public ResponseEntity<AuthenticationParamResponse> getAuthParams(HttpServletRequest request) throws GenericException {
		logger.info("Received the request for authParam");
		String sessionId = getSessionId(request);
		AuthenticationParamResponse authenticationParamResponse = null;
		try {
			authenticationParamResponse = authenticatorService.getAuthParams(sessionId);
		} catch (Exception e) {
			logger.error("Error in getting auth params" + e);
			e.printStackTrace();
		}
		
		return new ResponseEntity<AuthenticationParamResponse>(authenticationParamResponse, HttpStatus.OK);
	}*/
	
/*	*//**
	 * This service is added to get the latest station and claim count details for the logged-in user
	 * @param userName
	 * @return
	 * @throws GenericException
	 *//*
	@RequestMapping(value="/refreshStats/{userName}", method = RequestMethod.GET, produces = "application/json")
	public ResponseEntity<UserStationDetails> getUpdatedStats(@PathVariable String userName) throws GenericException {
		logger.info("Received the request to get the updated counts for userName "+userName);
		try {
		UserStationDetails userStationDetails = authenticatorService.getUpdatedUserStationDetails(userName);
		return new ResponseEntity<>(userStationDetails,HttpStatus.OK);
		} catch(GenericException e) {
			logger.error("getUpdatedStats : Exception is raised ");
			throw e;
		}
	}
	
	private String getSessionId(HttpServletRequest hreq){
        HttpSession session = hreq.getSession();
        return session.getId() + session.hashCode();
	}*/
		
}

