package gov.va.med.ars.controller;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import gov.va.med.ars.exceptions.GenericException;
import gov.va.med.ars.model.request.ArsMailRequest;
import gov.va.med.ars.service.IArsMailService;
import net.minidev.json.JSONObject;

@RestController
public class ArsMailController {
	
	private static final Logger log = LogManager.getLogger(ArsMailController.class);
	
	@Autowired
	IArsMailService arsMailService;
	
	@PostMapping(value = "/api/v1/sendMail")
	public ResponseEntity<?> submitRfaiRequest(@RequestBody ArsMailRequest request) throws GenericException {
		
		ResponseEntity<?> response = null;
		String result = "";
		
		try {
			result = arsMailService.sendArsMail(request);
			
		} catch(Exception e) {
			log.info("Error occured", e.getMessage());
		}
		
		JSONObject jsonResponse = new JSONObject();
		jsonResponse.put("result", result);

		response = new ResponseEntity<>(jsonResponse, HttpStatus.CREATED);
		return response;
	}	
}