package gov.va.med.ars.controller;

import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import gov.va.med.ars.exceptions.GenericException;
import gov.va.med.ars.model.request.EmailTemplateRequest;
import gov.va.med.ars.service.IArsEmailTemplateService;
import net.minidev.json.JSONObject;



@RestController
@RequestMapping("/api/v1/email")
public class ArsEmailTemplateController {
	
	private static final Logger log = LogManager.getLogger(ArsEmailTemplateController.class);
	
	@Autowired
	IArsEmailTemplateService arsEmailTemplateService;
	
	@GetMapping("/templates")
	public ResponseEntity<?> getEmailTemplate() throws GenericException {
		try { 
			List<EmailTemplateRequest> emailTemplate = arsEmailTemplateService.getEmailTemplate();
			JSONObject emailTemplates = new JSONObject();
			emailTemplates.put("emailTemplates", emailTemplate);
			if(emailTemplate == null) {
				return new ResponseEntity<>("No EmailTemplateRequest found", HttpStatus.NOT_FOUND);

			} else 
				return new ResponseEntity<>(emailTemplates, HttpStatus.OK);
			
		} catch(Exception e) {
			log.error(
					"ArsEmailTemplateRequestController:getEmailTemplate() exception occurred " + e.getMessage());
			throw e;
		}
	}
	
	@PutMapping("/updateTemplate")
	public ResponseEntity<?> updateEmailTemplate(@RequestBody EmailTemplateRequest request) throws GenericException {
		try { 
			boolean result = arsEmailTemplateService.updateEmailTemplate(request);

			JSONObject entity = new JSONObject();
			entity.put("result", result);
			return new ResponseEntity<>(entity, HttpStatus.OK);
			
		} catch(Exception e) {
			log.error(
					"ArsEmailTemplateRequestController:updateEmailTemplate() exception occured " + e.getMessage());
			throw e;
		}
	}
}