package gov.va.med.ars.controller;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import gov.va.med.ars.exceptions.GenericException;
import gov.va.med.ars.model.response.AttachmentsStorageResponse;
import gov.va.med.ars.service.IArsAttachmentsStorageService;

@RestController
@RequestMapping("/api/v1/attachments")
public class ArsAttachmentsStorageController {
	
	private static final Logger logger = LogManager.getLogger(ArsAttachmentsStorageController.class);
	
	@Autowired
	private IArsAttachmentsStorageService arsStorageService;
	
	@GetMapping("/storageInfo")
	public ResponseEntity<?> getAttachemntsStorageInfo() throws GenericException {
		
		try {
			AttachmentsStorageResponse response = arsStorageService.getAttachemntsStorageInfo();
			
			if(response == null) {
				return new ResponseEntity<>("No attachment info found", HttpStatus.NOT_FOUND);

			} else 
				return new ResponseEntity<>(response, HttpStatus.OK);
			
		} catch(Exception e) {
			
			logger.error("ArsAttachmentsStorageController:getAttachemntsStorageInfo() exception occurred " + e.getMessage());
			throw e;
		}
	}
}