/**
 * 
 */
package gov.va.med.ars.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import gov.va.med.ars.service.IArchiveService;
import gov.va.med.ars.validators.NumberValidator;
import net.minidev.json.JSONObject;

/**
 * @author PII
 *
 */
@RestController
@RequestMapping("/api/v1/archive")
public class ArchiveRestController {

	@Autowired
	IArchiveService archiveService;

	@GetMapping("/{attachId}")
	public ResponseEntity<?> archiveElements(@PathVariable("attachId") Long attachId) {
		JSONObject response = null;
		if (attachId != null) {
			boolean archived = archiveService.archiveAttachmentId(attachId);
			if (archived) {
				response = new JSONObject();
				response.put("response", archived);
				return new ResponseEntity<>(response, HttpStatus.OK);
			} else {
				response = new JSONObject();
				response.put("errorCode", "Invalid Request");
				response.put("message", "Please enter in a valid Claim ID or PDI.");
				return new ResponseEntity<>(response, HttpStatus.BAD_REQUEST);
			}
		} else {
			response = new JSONObject();
			response.put("errorCode", "Invalid Request");
			response.put("message", "Claim ID or PDI cannot be null.");
			return new ResponseEntity<>(response, HttpStatus.BAD_REQUEST);
		}
	}

}
