package gov.va.med.ars.configuration.security;


import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.oauth2.config.annotation.configurers.ClientDetailsServiceConfigurer;
import org.springframework.security.oauth2.config.annotation.web.configuration.AuthorizationServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableAuthorizationServer;
import org.springframework.security.oauth2.config.annotation.web.configurers.AuthorizationServerEndpointsConfigurer;
import org.springframework.security.oauth2.provider.token.TokenStore;
import org.springframework.security.oauth2.provider.token.store.JwtAccessTokenConverter;
import org.springframework.security.oauth2.provider.token.store.JwtTokenStore;
import org.springframework.security.oauth2.provider.token.store.KeyStoreKeyFactory;

/**
 * 
 * @author PII
 *
 */
@Configuration
@EnableAuthorizationServer
public class OAuth2AuthorizationServerConfig extends AuthorizationServerConfigurerAdapter {
	
	@Autowired
	@Qualifier("authenticationManagerBean")
	private AuthenticationManager authenticationManager;
	
	@Autowired
	Environment env;
	
	@Bean
	public TokenStore tokenStore() {
		return new JwtTokenStore(jwtTokenEnhancer());
	}
	
	@Override
	public void configure( ClientDetailsServiceConfigurer clients) throws Exception {
		clients.inMemory()
			.withClient(env.getProperty("oauth2.authorization.client.clientname"))
			.authorizedGrantTypes(env.getProperty("oauth2.authorization.client.grantType.password"),env.getProperty("oauth2.authorization.client.grantType.authorizationCode"),env.getProperty("oauth2.authorization.client.grantType.refreshToken"),env.getProperty("oauth2.authorization.client.grantType.implicit"))
			.authorities(env.getProperty("oauth2.authorization.client.authorities.roleClient"),env.getProperty("oauth2.authorization.client.authorities.roleTrustedClient"))
			.scopes(env.getProperty("oauth2.authorization.client.scope.read"),env.getProperty("oauth2.authorization.client.scope.write"),env.getProperty("oauth2.authorization.client.scope.trust"))
			.secret(env.getProperty("oauth2.authorization.client.secret"))
			.accessTokenValiditySeconds(Integer.parseInt(env.getProperty("oauth2.authorization.client.accessTokenValiditySecond")))
			.refreshTokenValiditySeconds(Integer.parseInt(env.getProperty("oauth2.authorization.client.refreshTokenValiditySecond")))
			.and()
			.withClient(env.getProperty("oauth2.authorization.client.clientname2"))
			.authorizedGrantTypes(env.getProperty("oauth2.authorization.client.grantType.password2"),env.getProperty("oauth2.authorization.client.grantType.authorizationCode2"),env.getProperty("oauth2.authorization.client.grantType.refreshToken2"),env.getProperty("oauth2.authorization.client.grantType.implicit2"))
			.authorities(env.getProperty("oauth2.authorization.client.authorities.roleClient2"),env.getProperty("oauth2.authorization.client.authorities.roleTrustedClient2"))
			.scopes(env.getProperty("oauth2.authorization.client.scope.read2"),env.getProperty("oauth2.authorization.client.scope.write2"),env.getProperty("oauth2.authorization.client.scope.trust2"))
			.secret(env.getProperty("oauth2.authorization.client.secret2"))
			.accessTokenValiditySeconds(Integer.parseInt(env.getProperty("oauth2.authorization.client.accessTokenValiditySecond2")))
			.refreshTokenValiditySeconds(Integer.parseInt(env.getProperty("oauth2.authorization.client.refreshTokenValiditySecond2")));
	}
	
	@Override
	public void configure(AuthorizationServerEndpointsConfigurer endpoints) throws Exception {
		endpoints.tokenStore(tokenStore())
		.tokenEnhancer(jwtTokenEnhancer()).authenticationManager(authenticationManager);
	}

	public JwtAccessTokenConverter jwtTokenEnhancer() {
		KeyStoreKeyFactory keyStoreFactory = new KeyStoreKeyFactory(new ClassPathResource("ARS_JWT.jks"),"VACCSE".toCharArray());
		JwtAccessTokenConverter converter = new JwtAccessTokenConverter();
		converter.setKeyPair(keyStoreFactory.getKeyPair(env.getProperty("oauth2.authorization.jwt.keypair")));
		return converter;
	}
	
}