/**
 * 
 */
package gov.va.med.ars.configuration.hibernate;

import java.util.HashMap;

import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.orm.hibernate5.HibernateExceptionTranslator;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

/**
 * @author PII
 *
 */
@Configuration
@EnableTransactionManagement
@EnableJpaRepositories(basePackages = "gov.va.med.ars.dao.ewv", entityManagerFactoryRef = "ewvEntityManager", transactionManagerRef = "ewvTransactionManager")
public class EwvPersistenceConfig {

	@Autowired
	private Environment env;

	@Value("$(init-db:false)")
	private String initDatabase;

	@Bean(name = "ewvEntityManager")
	public LocalContainerEntityManagerFactoryBean ewvEntityManager() {
		final LocalContainerEntityManagerFactoryBean em = new LocalContainerEntityManagerFactoryBean();
		em.setDataSource(ewvDataSource());
		em.setPackagesToScan(new String[] { "gov.va.med.domain.ewv" });

		final HibernateJpaVendorAdapter vendorAdapter = new HibernateJpaVendorAdapter();
		em.setJpaVendorAdapter(vendorAdapter);
		final HashMap<String, Object> properties = new HashMap<String, Object>();
		properties.put("hibernate.hbm2ddl.auto", env.getProperty("hibernate.hbm2ddl.auto"));
		properties.put("hibernate.dialect", env.getProperty("hibernate.dialect"));
		em.setJpaPropertyMap(properties);

		return em;
	}

	@Bean(name = "ewvDataSource")
	public DataSource ewvDataSource() {
		final DriverManagerDataSource dataSource = new DriverManagerDataSource();
		dataSource.setDriverClassName(env.getProperty("jdbc.ewv.driverClassName"));
		dataSource.setUrl(env.getProperty("jdbc.ewv.url"));
		dataSource.setUsername(env.getProperty("jdbc.ewv.username"));
		dataSource.setPassword(env.getProperty("jdbc.ewv.password"));

		return dataSource;
	}

	@Bean
	public HibernateExceptionTranslator hibernateExceptionTranslator() {
		return new HibernateExceptionTranslator();
	}

	@Bean(name = "ewvTransactionManager")
	public PlatformTransactionManager ewvTransactionManager() {
		EntityManagerFactory factory = ewvEntityManager().getObject();
		
		return new JpaTransactionManager(factory);
	}

}
