/**
 * 
 */
package gov.va.med.ars.configuration.hibernate;

import java.util.HashMap;

import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.orm.hibernate5.HibernateExceptionTranslator;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

/**
 * @author PII
 *
 */
@Configuration
@EnableTransactionManagement
@EnableJpaRepositories(basePackages = "gov.va.med.ars.dao.erepos", entityManagerFactoryRef = "eReposEntityManager", transactionManagerRef = "eReposTransactionManager")
public class EReposPersistenceConfig {

	@Autowired
	private Environment env;

	@Value("$(init-db:false)")
	private String initDatabase;

	@Bean(name = "eReposEntityManager")
	public LocalContainerEntityManagerFactoryBean eReposEntityManager() {
		final LocalContainerEntityManagerFactoryBean em = new LocalContainerEntityManagerFactoryBean();
		em.setDataSource(eReposDataSource());
		em.setPackagesToScan(new String[] { "gov.va.med.domain.ereposModel" });

		final HibernateJpaVendorAdapter vendorAdapter = new HibernateJpaVendorAdapter();
		em.setJpaVendorAdapter(vendorAdapter);
		final HashMap<String, Object> properties = new HashMap<String, Object>();
		properties.put("hibernate.hbm2ddl.auto", env.getProperty("hibernate.hbm2ddl.auto"));
		properties.put("hibernate.dialect", env.getProperty("hibernate.dialect"));
		em.setJpaPropertyMap(properties);

		return em;
	}

	@Bean(name = "eReposDataSource")
	public DataSource eReposDataSource() {
		final DriverManagerDataSource dataSource = new DriverManagerDataSource();
		dataSource.setDriverClassName(env.getProperty("jdbc.erepos.driverClassName"));
		dataSource.setUrl(env.getProperty("jdbc.erepos.url"));
		dataSource.setUsername(env.getProperty("jdbc.erepos.username"));
		dataSource.setPassword(env.getProperty("jdbc.erepos.password"));

		return dataSource;
	}

	@Bean
	public HibernateExceptionTranslator hibernateExceptionTranslator() {
		return new HibernateExceptionTranslator();
	}

	@Bean(name = "eReposTransactionManager")
	public PlatformTransactionManager eReposTransactionManager() {
		EntityManagerFactory factory = eReposEntityManager().getObject();
		
		return new JpaTransactionManager(factory);
	}

}
