------- TABLE OAUTH_ACCESS_TOKEN -----------------------
CREATE TABLE ARS_OWNER.oauth_access_token
(
	`token_id` VARCHAR2(256 BYTE) DEFAULT NULL,
	`token` blob,
	`authentication_id` VARCHAR2(256 BYTE) DEFAULT NULL,
	`user_name` VARCHAR2(256 BYTE) DEFAULT NULL,
	`client_id` VARCHAR2(256 BYTE) DEFAULT NULL,
	`authentication` CHAR(1 BYTE),
	`refresh_token` VARCHAR2(256 BYTE) DEFAULT NULL,
	CONSTRAINT OAUTH_ACCESS_TOKEN PRIMARY KEY
	(
		authentication_id
	)
)

-------------- TABLE OAUTH_CLIENT_DETAILS -----------
CREATE TABLE ARS_OWNER.oauth_client_details
(
	`client_id` VARCHAR2(255 BYTE) NOT NULL,
	`resource_ids` VARCHAR2(256 BYTE) DEFAULT NULL,
	`client_secret` VARCHAR2(256 BYTE) DEFAULT NULL,
	`app_scope` VARCHAR2(256 BYTE) DEFAULT NULL,
	`authorized_grant_types` VARCHAR2(256 BYTE) DEFAULT NULL,
	`web_server_redirect_url` VARCHAR2(256 BYTE) DEFAULT NULL,
	`authorities` VARCHAR2(256 BYTE) DEFAULT NULL,
	`access_token_validity` NUMBER(11,0) DEFAULT NULL,
	`refresh_token_validity` NUMBER(11,0) DEFAULT NULL,
	`additional_information` VARCHAR2(4096 BYTE) DEFAULT NULL,
	CONSTRAINT OAUTH_CLIENT_DETAILS_PK PRIMARY KEY
	(
		client_id
	)
)

-------------- TABLE OAUTH_client_token ---------------------
CREATE TABLE ARS_OWNER.oauth_client_token
(
	`token_id` VARCHAR2(256 BYTE) DEFAULT NULL,
	`token` BLOB,
	`authentication_id` VARCHAR2(255 BYTE),
	`user_name` VARCHAR2(255 BYTE),
	`client_id` VARCHAR2(255 BYTE)
)

--------------- TABLE OAUTH_REFRESH_TOKEN ------------------
CREATE TABLE ARS_OWNER.oauth_refresh_token
(
	`token_id` VARCHAR2(256 BYTE) DEFAULT NULL,
	`token` BLOB,
	`authentication` BLOB
)

------------- TABLE OAUTH_CODE ------------------------
CREATE TABLE ARS_OWNER.oauth_code
(
	`code` VARCHAR2(256 BYTE) DEFAULT NULL
)

------------- TABLE ClientDetails ------------------------
CREATE TABLE ARS_OWNER.ClientDetails
(
	`appId` VARCHAR(255 BYTE),
	`resource_ids` VARCHAR(255 BYTE),
	`appSecret` VARCHAR(255 BYTE),
	`app_scope` VARCHAR(255 BYTE),
	`grantTypes` VARCHAR(255 BYTE),
	`redirectUrl` VARCHAR(255 BYTE),
	`authorities` VARCHAR(255 BYTE),
	`access_token_validity` INTEGER,
	`refresh_token_validity` INTEGER,
	`additionalInformation` VARCHAR(4096)
	
)

-------------- TABLE oauth-approvals  -----------------------
CREATE TABLE ARS_OWNER.oauth_approvals
(
	userId VARCHAR2(255 BYTE),
	client_id VARCHAR2(255 BYTE),
	app_scope VARCHAR2(255 BYTE),
	status VARCHAR2(10 BYTE),
	expiresAt TIMESTAMP,
	lastModifiedAt TIMESTAMP
)