package gov.va.med.domain.fee;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import javax.persistence.*;

/**
 * The persistent class for the CLAIM_PROCEDURE_OHI_ADJUST database table.
 * 
 */
@Entity(name = "fClaimProcedureOhiAdjust")
@Table(name = "CLAIM_PROCEDURE_OHI_ADJUST")
public class ClaimProcedureOhiAdjust implements Serializable {
	private static final long serialVersionUID = 1L;

	private long claimProcOhiAdjId;
	private ClaimProcedureOhi claimProcedureOhi;
	private String primaryPayerId;
	private AdjustmentGroup adjustmentGroup;
	private AdjustmentReason adjustmentReason;
	private BigDecimal adjustmentAmount;
	private String quantity;
	private String createdBy;
	private Date dateCreated;

	public ClaimProcedureOhiAdjust() {
	}

	public ClaimProcedureOhiAdjust(long claimProcOhiAdjId, ClaimProcedureOhi claimProcedureOhi, String createdBy,
			Date dateCreated) {
		super();
		this.claimProcOhiAdjId = claimProcOhiAdjId;
		this.claimProcedureOhi = claimProcedureOhi;
		this.createdBy = createdBy;
		this.dateCreated = dateCreated;
	}

	public ClaimProcedureOhiAdjust(long claimProcOhiAdjId, ClaimProcedureOhi claimProcedureOhi, String primaryPayerId,
			AdjustmentGroup adjustmentGroup, AdjustmentReason adjustmentReason, BigDecimal adjustmentAmount,
			String quantity, String createdBy, Date dateCreated) {
		super();
		this.claimProcOhiAdjId = claimProcOhiAdjId;
		this.claimProcedureOhi = claimProcedureOhi;
		this.primaryPayerId = primaryPayerId;
		this.adjustmentGroup = adjustmentGroup;
		this.adjustmentReason = adjustmentReason;
		this.adjustmentAmount = adjustmentAmount;
		this.quantity = quantity;
		this.createdBy = createdBy;
		this.dateCreated = dateCreated;
	}

	@Id
	@GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "f_seq")
	@SequenceGenerator(name = "f_seq", sequenceName = "FPPS_OWNER.MIG")
	@Column(name = "CLAIM_PROC_OHI_ADJ_ID", unique = true, nullable = false, precision = 15, scale = 0)
	public long getClaimProcOhiAdjId() {
		return claimProcOhiAdjId;
	}

	public void setClaimProcOhiAdjId(long claimProcOhiAdjId) {
		this.claimProcOhiAdjId = claimProcOhiAdjId;
	}

	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name = "CLAIM_PROC_OHI_ID", nullable = false)
	public ClaimProcedureOhi getClaimProcedureOhi() {
		return claimProcedureOhi;
	}

	public void setClaimProcedureOhi(ClaimProcedureOhi claimProcedureOhi) {
		this.claimProcedureOhi = claimProcedureOhi;
	}

	@Column(name = "PRIMARY_PAYER_ID", length = 20)
	public String getPrimaryPayerId() {
		return primaryPayerId;
	}

	public void setPrimaryPayerId(String primaryPayerId) {
		this.primaryPayerId = primaryPayerId;
	}

	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name = "ADJUSTMENT_GROUP_CD")
	public AdjustmentGroup getAdjustmentGroup() {
		return adjustmentGroup;
	}

	public void setAdjustmentGroup(AdjustmentGroup adjustmentGroup) {
		this.adjustmentGroup = adjustmentGroup;
	}

	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name = "ADJUSTMENT_REASON_CD")
	public AdjustmentReason getAdjustmentReason() {
		return adjustmentReason;
	}

	public void setAdjustmentReason(AdjustmentReason adjustmentReason) {
		this.adjustmentReason = adjustmentReason;
	}

	@Column(name = "ADJUSTMENT_AMOUNT", precision = 10)
	public BigDecimal getAdjustmentAmount() {
		return adjustmentAmount;
	}

	public void setAdjustmentAmount(BigDecimal adjustmentAmount) {
		this.adjustmentAmount = adjustmentAmount;
	}

	@Column(name = "QUANTITY", length = 15)
	public String getQuantity() {
		return quantity;
	}

	public void setQuantity(String quantity) {
		this.quantity = quantity;
	}

	@Column(name = "CREATED_BY", nullable = false, length = 30)
	public String getCreatedBy() {
		return createdBy;
	}

	public void setCreatedBy(String createdBy) {
		this.createdBy = createdBy;
	}

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "DATE_CREATED", nullable = false, length = 7)
	public Date getDateCreated() {
		return dateCreated;
	}

	public void setDateCreated(Date dateCreated) {
		this.dateCreated = dateCreated;
	}
}