package gov.va.med.domain.fee;

import java.io.Serializable;
import javax.persistence.*;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;

/**
 * The persistent class for the CLAIM_OHI database table.
 * 
 */
@Entity(name = "fClaimOhi")
@Table(name = "CLAIM_OHI")
public class ClaimOhi implements Serializable {
	private static final long serialVersionUID = 1L;

	private long claimOhiId;
	private Claim claim;
	private String ohiPayerId;
	private String otherPayerName;
	private String paymentSequenceIndicator;
	private String ohiGroupName;
	private String filingIndicator;
	private String benefitsAssignmentIndicator;
	private String insuranceType;
	private String claimAdjustmentDate;
	private String cobSubmittedCharges;
	private String cobTotalAllowedAmt;
	private String cobApprovedAmt;
	private String cobTotalNoncoveredAmt;
	private String cobPayerPaidAmt;
	private String cobTotalDeniedAmt;
	private String cobTotalMedicarePaidAmt;
	private String cobPatientPaidAmt;
	private String cobMedicarePaidAmt100;
	private String cobPatientResponsibility;
	private String cobMedicarePaidAmt80;
	private String cobMedicareATrustFund;
	private String cobMedicareBTrustFund;
	private String inpCoveredDays;
	private String inpLifetimeReserveDays;
	private String inpLifetimePsychiatricDays;
	private String inpClaimDrgAmt;
	private String inpClaimDisproporShare;
	private String inpMspPassThroughAmt;
	private String inpClaimPpsCapitalAmt;
	private String inpPpsCapitalFspDrgAmt;
	private String inpPpsCapitalHspDrgAmt;
	private String inpPpsCapitalDshDrgAmt;
	private String inpOldCapitalAmt;
	private String inpPpsCapitalImeAmt;
	private String inpPpsOperHospSpecDrgAmt;
	private String inpPpsOperFedSpecDrgAmt;
	private String inpPpsCapitalOutlrAmt;
	private String inpClaimIndirectTeachAmt;
	private String inpNonpayableProfComponent;
	private String inpPpsCapitalExceptionAmt;
	private String inpCostReportDayCount;
	private String inpRemittanceRemarkCode1;
	private String inpRemittanceRemarkCode2;
	private String inpRemittanceRemarkCode3;
	private String inpRemittanceRemarkCode4;
	private String inpRemittanceRemarkCode5;
	private String optReimbursementRate;
	private String optEsrdPaidAmt;
	private String optClaimHcpcsPayableAmt;
	private String optNonpayableProfComponent;
	private String optRemittanceRemarkCode1;
	private String optRemittanceRemarkCode2;
	private String optRemittanceRemarkCode3;
	private String optRemittanceRemarkCode4;
	private String optRemittanceRemarkCode5;
	private String createdBy;
	private Date dateCreated;
	private String otherSubscriberInfo;
	private String subscriberIdCode;
	private String secondarysubscriberIdCode;
	private String payerPriorAuthNum;
	private String payerPriorReferralNum;
	private Set<ClaimOhiAdjust> claimOhiAdjusts = new HashSet<ClaimOhiAdjust>(0);

	public ClaimOhi() {

	}

	public ClaimOhi(long claimOhiId, Claim claim, String createdBy, Date dateCreated) {
		this.claimOhiId = claimOhiId;
		this.claim = claim;
		this.createdBy = createdBy;
		this.dateCreated = dateCreated;
	}

	public ClaimOhi(long claimOhiId, Claim claim, String ohiPayerId, String otherPayerName,
			String paymentSequenceIndicator, String ohiGroupName, String filingIndicator,
			String benefitsAssignmentIndicator, String insuranceType, String claimAdjustmentDate,
			String cobSubmittedCharges, String cobTotalAllowedAmt, String cobApprovedAmt, String cobTotalNoncoveredAmt,
			String cobPayerPaidAmt, String cobTotalDeniedAmt, String cobTotalMedicarePaidAmt, String cobPatientPaidAmt,
			String cobMedicarePaidAmt100, String cobPatientResponsibility, String cobMedicarePaidAmt80,
			String cobMedicareATrustFund, String cobMedicareBTrustFund, String inpCoveredDays,
			String inpLifetimeReserveDays, String inpLifetimePsychiatricDays, String inpClaimDrgAmt,
			String inpClaimDisproporShare, String inpMspPassThroughAmt, String inpClaimPpsCapitalAmt,
			String inpPpsCapitalFspDrgAmt, String inpPpsCapitalHspDrgAmt, String inpPpsCapitalDshDrgAmt,
			String inpOldCapitalAmt, String inpPpsCapitalImeAmt, String inpPpsOperHospSpecDrgAmt,
			String inpPpsOperFedSpecDrgAmt, String inpPpsCapitalOutlrAmt, String inpClaimIndirectTeachAmt,
			String inpNonpayableProfComponent, String inpPpsCapitalExceptionAmt, String inpCostReportDayCount,
			String inpRemittanceRemarkCode1, String inpRemittanceRemarkCode2, String inpRemittanceRemarkCode3,
			String inpRemittanceRemarkCode4, String inpRemittanceRemarkCode5, String optReimbursementRate,
			String optEsrdPaidAmt, String optClaimHcpcsPayableAmt, String optNonpayableProfComponent,
			String optRemittanceRemarkCode1, String optRemittanceRemarkCode2, String optRemittanceRemarkCode3,
			String optRemittanceRemarkCode4, String optRemittanceRemarkCode5, String createdBy, Date dateCreated,
			String otherSubscriberInfo, String subscriberIdCode, String secondarysubscriberIdCode,
			String payerPriorAuthNum, String payerPriorReferralNum, Set<ClaimOhiAdjust> claimOhiAdjusts) {
		this.claimOhiId = claimOhiId;
		this.claim = claim;
		this.ohiPayerId = ohiPayerId;
		this.otherPayerName = otherPayerName;
		this.paymentSequenceIndicator = paymentSequenceIndicator;
		this.ohiGroupName = ohiGroupName;
		this.filingIndicator = filingIndicator;
		this.benefitsAssignmentIndicator = benefitsAssignmentIndicator;
		this.insuranceType = insuranceType;
		this.claimAdjustmentDate = claimAdjustmentDate;
		this.cobSubmittedCharges = cobSubmittedCharges;
		this.cobTotalAllowedAmt = cobTotalAllowedAmt;
		this.cobApprovedAmt = cobApprovedAmt;
		this.cobTotalNoncoveredAmt = cobTotalNoncoveredAmt;
		this.cobPayerPaidAmt = cobPayerPaidAmt;
		this.cobTotalDeniedAmt = cobTotalDeniedAmt;
		this.cobTotalMedicarePaidAmt = cobTotalMedicarePaidAmt;
		this.cobPatientPaidAmt = cobPatientPaidAmt;
		this.cobMedicarePaidAmt100 = cobMedicarePaidAmt100;
		this.cobPatientResponsibility = cobPatientResponsibility;
		this.cobMedicarePaidAmt80 = cobMedicarePaidAmt80;
		this.cobMedicareATrustFund = cobMedicareATrustFund;
		this.cobMedicareBTrustFund = cobMedicareBTrustFund;
		this.inpCoveredDays = inpCoveredDays;
		this.inpLifetimeReserveDays = inpLifetimeReserveDays;
		this.inpLifetimePsychiatricDays = inpLifetimePsychiatricDays;
		this.inpClaimDrgAmt = inpClaimDrgAmt;
		this.inpClaimDisproporShare = inpClaimDisproporShare;
		this.inpMspPassThroughAmt = inpMspPassThroughAmt;
		this.inpClaimPpsCapitalAmt = inpClaimPpsCapitalAmt;
		this.inpPpsCapitalFspDrgAmt = inpPpsCapitalFspDrgAmt;
		this.inpPpsCapitalHspDrgAmt = inpPpsCapitalHspDrgAmt;
		this.inpPpsCapitalDshDrgAmt = inpPpsCapitalDshDrgAmt;
		this.inpOldCapitalAmt = inpOldCapitalAmt;
		this.inpPpsCapitalImeAmt = inpPpsCapitalImeAmt;
		this.inpPpsOperHospSpecDrgAmt = inpPpsOperHospSpecDrgAmt;
		this.inpPpsOperFedSpecDrgAmt = inpPpsOperFedSpecDrgAmt;
		this.inpPpsCapitalOutlrAmt = inpPpsCapitalOutlrAmt;
		this.inpClaimIndirectTeachAmt = inpClaimIndirectTeachAmt;
		this.inpNonpayableProfComponent = inpNonpayableProfComponent;
		this.inpPpsCapitalExceptionAmt = inpPpsCapitalExceptionAmt;
		this.inpCostReportDayCount = inpCostReportDayCount;
		this.inpRemittanceRemarkCode1 = inpRemittanceRemarkCode1;
		this.inpRemittanceRemarkCode2 = inpRemittanceRemarkCode2;
		this.inpRemittanceRemarkCode3 = inpRemittanceRemarkCode3;
		this.inpRemittanceRemarkCode4 = inpRemittanceRemarkCode4;
		this.inpRemittanceRemarkCode5 = inpRemittanceRemarkCode5;
		this.optReimbursementRate = optReimbursementRate;
		this.optEsrdPaidAmt = optEsrdPaidAmt;
		this.optClaimHcpcsPayableAmt = optClaimHcpcsPayableAmt;
		this.optNonpayableProfComponent = optNonpayableProfComponent;
		this.optRemittanceRemarkCode1 = optRemittanceRemarkCode1;
		this.optRemittanceRemarkCode2 = optRemittanceRemarkCode2;
		this.optRemittanceRemarkCode3 = optRemittanceRemarkCode3;
		this.optRemittanceRemarkCode4 = optRemittanceRemarkCode4;
		this.optRemittanceRemarkCode5 = optRemittanceRemarkCode5;
		this.createdBy = createdBy;
		this.dateCreated = dateCreated;
		this.claimOhiAdjusts = claimOhiAdjusts;
		this.otherSubscriberInfo = otherSubscriberInfo;
		this.subscriberIdCode = subscriberIdCode;
		this.secondarysubscriberIdCode = secondarysubscriberIdCode;
		this.payerPriorAuthNum = payerPriorAuthNum;
		this.payerPriorReferralNum = payerPriorReferralNum;
	}

	@Id
	@GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "f_seq")
	@SequenceGenerator(name = "f_seq", sequenceName = "FPPS_OWNER.MIG")
	@Column(name = "CLAIM_OHI_ID", unique = true, nullable = false, precision = 15, scale = 0)
	public long getClaimOhiId() {
		return claimOhiId;
	}

	public void setClaimOhiId(long claimOhiId) {
		this.claimOhiId = claimOhiId;
	}

	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name = "CLAIM_INDEX", nullable = false)
	public Claim getClaim() {
		return claim;
	}

	public void setClaim(Claim claim) {
		this.claim = claim;
	}

	@Column(name = "OHI_PAYER_ID", length = 30)
	public String getOhiPayerId() {
		return ohiPayerId;
	}

	public void setOhiPayerId(String ohiPayerId) {
		this.ohiPayerId = ohiPayerId;
	}

	@Column(name = "OTHER_PAYER_NAME", length = 50)
	public String getOtherPayerName() {
		return otherPayerName;
	}

	public void setOtherPayerName(String otherPayerName) {
		this.otherPayerName = otherPayerName;
	}

	@Column(name = "PAYMENT_SEQUENCE_INDICATOR", length = 2)
	public String getPaymentSequenceIndicator() {
		return paymentSequenceIndicator;
	}

	public void setPaymentSequenceIndicator(String paymentSequenceIndicator) {
		this.paymentSequenceIndicator = paymentSequenceIndicator;
	}

	@Column(name = "OHI_GROUP_NAME", length = 100)
	public String getOhiGroupName() {
		return ohiGroupName;
	}

	public void setOhiGroupName(String ohiGroupName) {
		this.ohiGroupName = ohiGroupName;
	}

	@Column(name = "FILING_INDICATOR", length = 2)
	public String getFilingIndicator() {
		return filingIndicator;
	}

	public void setFilingIndicator(String filingIndicator) {
		this.filingIndicator = filingIndicator;
	}

	@Column(name = "BENEFITS_ASSIGNMENT_INDICATOR", length = 1)
	public String getBenefitsAssignmentIndicator() {
		return benefitsAssignmentIndicator;
	}

	public void setBenefitsAssignmentIndicator(String benefitsAssignmentIndicator) {
		this.benefitsAssignmentIndicator = benefitsAssignmentIndicator;
	}

	@Column(name = "INSURANCE_TYPE", length = 10)
	public String getInsuranceType() {
		return insuranceType;
	}

	public void setInsuranceType(String insuranceType) {
		this.insuranceType = insuranceType;
	}

	@Column(name = "CLAIM_ADJUSTMENT_DATE", length = 10)
	public String getClaimAdjustmentDate() {
		return claimAdjustmentDate;
	}

	public void setClaimAdjustmentDate(String claimAdjustmentDate) {
		this.claimAdjustmentDate = claimAdjustmentDate;
	}

	@Column(name = "COB_SUBMITTED_CHARGES", length = 15)
	public String getCobSubmittedCharges() {
		return cobSubmittedCharges;
	}

	public void setCobSubmittedCharges(String cobSubmittedCharges) {
		this.cobSubmittedCharges = cobSubmittedCharges;
	}

	@Column(name = "COB_TOTAL_ALLOWED_AMT", length = 15)
	public String getCobTotalAllowedAmt() {
		return cobTotalAllowedAmt;
	}

	public void setCobTotalAllowedAmt(String cobTotalAllowedAmt) {
		this.cobTotalAllowedAmt = cobTotalAllowedAmt;
	}

	@Column(name = "COB_APPROVED_AMT", length = 15)
	public String getCobApprovedAmt() {
		return cobApprovedAmt;
	}

	public void setCobApprovedAmt(String cobApprovedAmt) {
		this.cobApprovedAmt = cobApprovedAmt;
	}

	@Column(name = "COB_TOTAL_NONCOVERED_AMT", length = 15)
	public String getCobTotalNoncoveredAmt() {
		return cobTotalNoncoveredAmt;
	}

	public void setCobTotalNoncoveredAmt(String cobTotalNoncoveredAmt) {
		this.cobTotalNoncoveredAmt = cobTotalNoncoveredAmt;
	}

	@Column(name = "COB_PAYER_PAID_AMT", length = 15)
	public String getCobPayerPaidAmt() {
		return cobPayerPaidAmt;
	}

	public void setCobPayerPaidAmt(String cobPayerPaidAmt) {
		this.cobPayerPaidAmt = cobPayerPaidAmt;
	}

	@Column(name = "COB_TOTAL_DENIED_AMT", length = 15)
	public String getCobTotalDeniedAmt() {
		return cobTotalDeniedAmt;
	}

	public void setCobTotalDeniedAmt(String cobTotalDeniedAmt) {
		this.cobTotalDeniedAmt = cobTotalDeniedAmt;
	}

	@Column(name = "COB_TOTAL_MEDICARE_PAID_AMT", length = 15)
	public String getCobTotalMedicarePaidAmt() {
		return cobTotalMedicarePaidAmt;
	}

	public void setCobTotalMedicarePaidAmt(String cobTotalMedicarePaidAmt) {
		this.cobTotalMedicarePaidAmt = cobTotalMedicarePaidAmt;
	}

	@Column(name = "COB_PATIENT_PAID_AMT", length = 15)
	public String getCobPatientPaidAmt() {
		return cobPatientPaidAmt;
	}

	public void setCobPatientPaidAmt(String cobPatientPaidAmt) {
		this.cobPatientPaidAmt = cobPatientPaidAmt;
	}

	@Column(name = "COB_MEDICARE_PAID_AMT_100", length = 15)
	public String getCobMedicarePaidAmt100() {
		return cobMedicarePaidAmt100;
	}

	public void setCobMedicarePaidAmt100(String cobMedicarePaidAmt100) {
		this.cobMedicarePaidAmt100 = cobMedicarePaidAmt100;
	}

	@Column(name = "COB_PATIENT_RESPONSIBILITY", length = 15)
	public String getCobPatientResponsibility() {
		return cobPatientResponsibility;
	}

	public void setCobPatientResponsibility(String cobPatientResponsibility) {
		this.cobPatientResponsibility = cobPatientResponsibility;
	}

	@Column(name = "COB_MEDICARE_PAID_AMT_80", length = 15)
	public String getCobMedicarePaidAmt80() {
		return cobMedicarePaidAmt80;
	}

	public void setCobMedicarePaidAmt80(String cobMedicarePaidAmt80) {
		this.cobMedicarePaidAmt80 = cobMedicarePaidAmt80;
	}

	@Column(name = "COB_MEDICARE_A_TRUST_FUND", length = 15)
	public String getCobMedicareATrustFund() {
		return cobMedicareATrustFund;
	}

	public void setCobMedicareATrustFund(String cobMedicareATrustFund) {
		this.cobMedicareATrustFund = cobMedicareATrustFund;
	}

	@Column(name = "COB_MEDICARE_B_TRUST_FUND", length = 15)
	public String getCobMedicareBTrustFund() {
		return cobMedicareBTrustFund;
	}

	public void setCobMedicareBTrustFund(String cobMedicareBTrustFund) {
		this.cobMedicareBTrustFund = cobMedicareBTrustFund;
	}

	@Column(name = "INP_COVERED_DAYS", length = 3)
	public String getInpCoveredDays() {
		return inpCoveredDays;
	}

	public void setInpCoveredDays(String inpCoveredDays) {
		this.inpCoveredDays = inpCoveredDays;
	}

	@Column(name = "INP_LIFETIME_RESERVE_DAYS", length = 3)
	public String getInpLifetimeReserveDays() {
		return inpLifetimeReserveDays;
	}

	public void setInpLifetimeReserveDays(String inpLifetimeReserveDays) {
		this.inpLifetimeReserveDays = inpLifetimeReserveDays;
	}

	@Column(name = "INP_LIFETIME_PSYCHIATRIC_DAYS", length = 3)
	public String getInpLifetimePsychiatricDays() {
		return inpLifetimePsychiatricDays;
	}

	public void setInpLifetimePsychiatricDays(String inpLifetimePsychiatricDays) {
		this.inpLifetimePsychiatricDays = inpLifetimePsychiatricDays;
	}

	@Column(name = "INP_CLAIM_DRG_AMT", length = 15)
	public String getInpClaimDrgAmt() {
		return inpClaimDrgAmt;
	}

	public void setInpClaimDrgAmt(String inpClaimDrgAmt) {
		this.inpClaimDrgAmt = inpClaimDrgAmt;
	}

	@Column(name = "INP_CLAIM_DISPROPOR_SHARE", length = 15)
	public String getInpClaimDisproporShare() {
		return inpClaimDisproporShare;
	}

	public void setInpClaimDisproporShare(String inpClaimDisproporShare) {
		this.inpClaimDisproporShare = inpClaimDisproporShare;
	}

	@Column(name = "INP_MSP_PASS_THROUGH_AMT", length = 15)
	public String getInpMspPassThroughAmt() {
		return inpMspPassThroughAmt;
	}

	public void setInpMspPassThroughAmt(String inpMspPassThroughAmt) {
		this.inpMspPassThroughAmt = inpMspPassThroughAmt;
	}

	@Column(name = "INP_CLAIM_PPS_CAPITAL_AMT", length = 15)
	public String getInpClaimPpsCapitalAmt() {
		return inpClaimPpsCapitalAmt;
	}

	public void setInpClaimPpsCapitalAmt(String inpClaimPpsCapitalAmt) {
		this.inpClaimPpsCapitalAmt = inpClaimPpsCapitalAmt;
	}

	@Column(name = "INP_PPS_CAPITAL_FSP_DRG_AMT", length = 15)
	public String getInpPpsCapitalFspDrgAmt() {
		return inpPpsCapitalFspDrgAmt;
	}

	public void setInpPpsCapitalFspDrgAmt(String inpPpsCapitalFspDrgAmt) {
		this.inpPpsCapitalFspDrgAmt = inpPpsCapitalFspDrgAmt;
	}

	@Column(name = "INP_PPS_CAPITAL_HSP_DRG_AMT", length = 15)
	public String getInpPpsCapitalHspDrgAmt() {
		return inpPpsCapitalHspDrgAmt;
	}

	public void setInpPpsCapitalHspDrgAmt(String inpPpsCapitalHspDrgAmt) {
		this.inpPpsCapitalHspDrgAmt = inpPpsCapitalHspDrgAmt;
	}

	@Column(name = "INP_PPS_CAPITAL_DSH_DRG_AMT", length = 15)
	public String getInpPpsCapitalDshDrgAmt() {
		return inpPpsCapitalDshDrgAmt;
	}

	public void setInpPpsCapitalDshDrgAmt(String inpPpsCapitalDshDrgAmt) {
		this.inpPpsCapitalDshDrgAmt = inpPpsCapitalDshDrgAmt;
	}

	@Column(name = "INP_OLD_CAPITAL_AMT", length = 15)
	public String getInpOldCapitalAmt() {
		return inpOldCapitalAmt;
	}

	public void setInpOldCapitalAmt(String inpOldCapitalAmt) {
		this.inpOldCapitalAmt = inpOldCapitalAmt;
	}

	@Column(name = "INP_PPS_CAPITAL_IME_AMT", length = 15)
	public String getInpPpsCapitalImeAmt() {
		return inpPpsCapitalImeAmt;
	}

	public void setInpPpsCapitalImeAmt(String inpPpsCapitalImeAmt) {
		this.inpPpsCapitalImeAmt = inpPpsCapitalImeAmt;
	}

	@Column(name = "INP_PPS_OPER_HOSP_SPEC_DRG_AMT", length = 15)
	public String getInpPpsOperHospSpecDrgAmt() {
		return inpPpsOperHospSpecDrgAmt;
	}

	public void setInpPpsOperHospSpecDrgAmt(String inpPpsOperHospSpecDrgAmt) {
		this.inpPpsOperHospSpecDrgAmt = inpPpsOperHospSpecDrgAmt;
	}

	@Column(name = "INP_PPS_OPER_FED_SPEC_DRG_AMT", length = 15)
	public String getInpPpsOperFedSpecDrgAmt() {
		return inpPpsOperFedSpecDrgAmt;
	}

	public void setInpPpsOperFedSpecDrgAmt(String inpPpsOperFedSpecDrgAmt) {
		this.inpPpsOperFedSpecDrgAmt = inpPpsOperFedSpecDrgAmt;
	}

	@Column(name = "INP_PPS_CAPITAL_OUTLR_AMT", length = 15)
	public String getInpPpsCapitalOutlrAmt() {
		return inpPpsCapitalOutlrAmt;
	}

	public void setInpPpsCapitalOutlrAmt(String inpPpsCapitalOutlrAmt) {
		this.inpPpsCapitalOutlrAmt = inpPpsCapitalOutlrAmt;
	}

	@Column(name = "INP_CLAIM_INDIRECT_TEACH_AMT", length = 15)
	public String getInpClaimIndirectTeachAmt() {
		return inpClaimIndirectTeachAmt;
	}

	public void setInpClaimIndirectTeachAmt(String inpClaimIndirectTeachAmt) {
		this.inpClaimIndirectTeachAmt = inpClaimIndirectTeachAmt;
	}

	@Column(name = "INP_NONPAYABLE_PROF_COMPONENT", length = 15)
	public String getInpNonpayableProfComponent() {
		return inpNonpayableProfComponent;
	}

	public void setInpNonpayableProfComponent(String inpNonpayableProfComponent) {
		this.inpNonpayableProfComponent = inpNonpayableProfComponent;
	}

	@Column(name = "INP_PPS_CAPITAL_EXCEPTION_AMT", length = 15)
	public String getInpPpsCapitalExceptionAmt() {
		return inpPpsCapitalExceptionAmt;
	}

	public void setInpPpsCapitalExceptionAmt(String inpPpsCapitalExceptionAmt) {
		this.inpPpsCapitalExceptionAmt = inpPpsCapitalExceptionAmt;
	}

	@Column(name = "INP_COST_REPORT_DAY_COUNT", length = 3)
	public String getInpCostReportDayCount() {
		return inpCostReportDayCount;
	}

	public void setInpCostReportDayCount(String inpCostReportDayCount) {
		this.inpCostReportDayCount = inpCostReportDayCount;
	}

	@Column(name = "INP_REMITTANCE_REMARK_CODE_1", length = 10)
	public String getInpRemittanceRemarkCode1() {
		return inpRemittanceRemarkCode1;
	}

	public void setInpRemittanceRemarkCode1(String inpRemittanceRemarkCode1) {
		this.inpRemittanceRemarkCode1 = inpRemittanceRemarkCode1;
	}

	@Column(name = "INP_REMITTANCE_REMARK_CODE_2", length = 10)
	public String getInpRemittanceRemarkCode2() {
		return inpRemittanceRemarkCode2;
	}

	public void setInpRemittanceRemarkCode2(String inpRemittanceRemarkCode2) {
		this.inpRemittanceRemarkCode2 = inpRemittanceRemarkCode2;
	}

	@Column(name = "INP_REMITTANCE_REMARK_CODE_3", length = 10)
	public String getInpRemittanceRemarkCode3() {
		return inpRemittanceRemarkCode3;
	}

	public void setInpRemittanceRemarkCode3(String inpRemittanceRemarkCode3) {
		this.inpRemittanceRemarkCode3 = inpRemittanceRemarkCode3;
	}

	@Column(name = "INP_REMITTANCE_REMARK_CODE_4", length = 10)
	public String getInpRemittanceRemarkCode4() {
		return inpRemittanceRemarkCode4;
	}

	public void setInpRemittanceRemarkCode4(String inpRemittanceRemarkCode4) {
		this.inpRemittanceRemarkCode4 = inpRemittanceRemarkCode4;
	}

	@Column(name = "INP_REMITTANCE_REMARK_CODE_5", length = 10)
	public String getInpRemittanceRemarkCode5() {
		return inpRemittanceRemarkCode5;
	}

	public void setInpRemittanceRemarkCode5(String inpRemittanceRemarkCode5) {
		this.inpRemittanceRemarkCode5 = inpRemittanceRemarkCode5;
	}

	@Column(name = "OPT_REIMBURSEMENT_RATE", length = 15)
	public String getOptReimbursementRate() {
		return optReimbursementRate;
	}

	public void setOptReimbursementRate(String optReimbursementRate) {
		this.optReimbursementRate = optReimbursementRate;
	}

	@Column(name = "OPT_ESRD_PAID_AMT", length = 15)
	public String getOptEsrdPaidAmt() {
		return optEsrdPaidAmt;
	}

	public void setOptEsrdPaidAmt(String optEsrdPaidAmt) {
		this.optEsrdPaidAmt = optEsrdPaidAmt;
	}

	@Column(name = "OPT_CLAIM_HCPCS_PAYABLE_AMT", length = 15)
	public String getOptClaimHcpcsPayableAmt() {
		return optClaimHcpcsPayableAmt;
	}

	public void setOptClaimHcpcsPayableAmt(String optClaimHcpcsPayableAmt) {
		this.optClaimHcpcsPayableAmt = optClaimHcpcsPayableAmt;
	}

	@Column(name = "OPT_NONPAYABLE_PROF_COMPONENT", length = 15)
	public String getOptNonpayableProfComponent() {
		return optNonpayableProfComponent;
	}

	public void setOptNonpayableProfComponent(String optNonpayableProfComponent) {
		this.optNonpayableProfComponent = optNonpayableProfComponent;
	}

	@Column(name = "OPT_REMITTANCE_REMARK_CODE1", length = 10)
	public String getOptRemittanceRemarkCode1() {
		return optRemittanceRemarkCode1;
	}

	public void setOptRemittanceRemarkCode1(String optRemittanceRemarkCode1) {
		this.optRemittanceRemarkCode1 = optRemittanceRemarkCode1;
	}

	@Column(name = "OPT_REMITTANCE_REMARK_CODE2", length = 10)
	public String getOptRemittanceRemarkCode2() {
		return optRemittanceRemarkCode2;
	}

	public void setOptRemittanceRemarkCode2(String optRemittanceRemarkCode2) {
		this.optRemittanceRemarkCode2 = optRemittanceRemarkCode2;
	}

	@Column(name = "OPT_REMITTANCE_REMARK_CODE3", length = 10)
	public String getOptRemittanceRemarkCode3() {
		return optRemittanceRemarkCode3;
	}

	public void setOptRemittanceRemarkCode3(String optRemittanceRemarkCode3) {
		this.optRemittanceRemarkCode3 = optRemittanceRemarkCode3;
	}

	@Column(name = "OPT_REMITTANCE_REMARK_CODE4", length = 10)
	public String getOptRemittanceRemarkCode4() {
		return optRemittanceRemarkCode4;
	}

	public void setOptRemittanceRemarkCode4(String optRemittanceRemarkCode4) {
		this.optRemittanceRemarkCode4 = optRemittanceRemarkCode4;
	}

	@Column(name = "OPT_REMITTANCE_REMARK_CODE5", length = 10)
	public String getOptRemittanceRemarkCode5() {
		return optRemittanceRemarkCode5;
	}

	public void setOptRemittanceRemarkCode5(String optRemittanceRemarkCode5) {
		this.optRemittanceRemarkCode5 = optRemittanceRemarkCode5;
	}

	@Column(name = "CREATED_BY", nullable = false, length = 30)
	public String getCreatedBy() {
		return createdBy;
	}

	public void setCreatedBy(String createdBy) {
		this.createdBy = createdBy;
	}

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "DATE_CREATED", nullable = false, length = 7)
	public Date getDateCreated() {
		return dateCreated;
	}

	public void setDateCreated(Date dateCreated) {
		this.dateCreated = dateCreated;
	}
	
	@Column(name = "OTHER_SUBSCRIBER_INFO", length = 134)
	public String getOtherSubscriberInfo() {
		return otherSubscriberInfo;
	}

	public void setOtherSubscriberInfo(String otherSubscriberInfo) {
		this.otherSubscriberInfo = otherSubscriberInfo;
	}

	@Column(name = "SUBSCRIBER_ID_CODE", length = 80)
	public String getSubscriberIdCode() {
		return subscriberIdCode;
	}

	public void setSubscriberIdCode(String subscriberIdCode) {
		this.subscriberIdCode = subscriberIdCode;
	}

	@Column(name = "SECONDARY_SUBSCRIBER_ID_CODE", length = 50)
	public String getSecondarysubscriberIdCode() {
		return secondarysubscriberIdCode;
	}

	public void setSecondarysubscriberIdCode(String secondarysubscriberIdCode) {
		this.secondarysubscriberIdCode = secondarysubscriberIdCode;
	}

	@Column(name = "PAYER_PRIOR_AUTH_NUM", length = 50)
	public String getPayerPriorAuthNum() {
		return payerPriorAuthNum;
	}

	public void setPayerPriorAuthNum(String payerPriorAuthNum) {
		this.payerPriorAuthNum = payerPriorAuthNum;
	}

	@Column(name = "PAYER_PRIOR_REFERRAL_NUM", length = 50)
	public String getPayerPriorReferralNum() {
		return payerPriorReferralNum;
	}

	public void setPayerPriorReferralNum(String payerPriorReferralNum) {
		this.payerPriorReferralNum = payerPriorReferralNum;
	}

	@OneToMany(fetch = FetchType.LAZY, mappedBy = "claimOhi", cascade = CascadeType.ALL)
	public Set<ClaimOhiAdjust> getClaimOhiAdjusts() {
		return claimOhiAdjusts;
	}

	public void setClaimOhiAdjusts(Set<ClaimOhiAdjust> claimOhiAdjusts) {
		this.claimOhiAdjusts = claimOhiAdjusts;
	}

}