import {
  Component,
  OnInit,
  Input,
  EventEmitter,
  Output,
  SimpleChange,
  ViewChild,
  ElementRef
} from '@angular/core';
import { TableService } from './table.service';
import {
  TableColumnModel,
  PaginationSettings,
  TableSettings
} from './table.component.model';

@Component({
  selector: 'app-table',
  templateUrl: './table.component.html',
  styleUrls: ['./table.component.scss']
})
export class TableComponent implements OnInit {
  @Input() paginationSettings: PaginationSettings;
  @Input() tableSettings: TableSettings;
  @Input() columns: TableColumnModel[];
  @Input() rows: any[] = [];
  @Output() notify = new EventEmitter();
  @Output() linkNotify = new EventEmitter();
  @Output() imgNotify = new EventEmitter();
  @Output() sortNotify = new EventEmitter();
  @ViewChild('rowVal') rowVal: ElementRef;
  // pagination settings
  pageSizes = [10, 15, 25, 100];
  currentPage = 1;
  // end of pagination settings
  selectAll = false;
  metaData: TableColumnModel[];
  data;

  constructor(private service: TableService) {}

  ngOnInit() {}
  linkButton(value) {
    this.linkNotify.emit(value);
  }
  buttonClicked(row) {
    console.log('row ', row);
  }
  imgClicked(row, imgIndex) {
    this.imgNotify.emit({ data: row, imgIndex });
  }
  isValANumber(val) {
    const reg = /\d{2}\/\d{2}\/\d{4}/;
    if (!isNaN(+val) || reg.test(val)) {
      return true;
    } else {
      return false;
    }
  }
  selectItems(bool) {
    this.selectAll = bool;
    this.rows.forEach(val => (val.row_selected = bool));
    return this.selectAll;
  }
  sortTable(column) {
    this.paginationSettings.sortColumn = column;
    this.paginationSettings.descending = !this.paginationSettings.descending;
    console.log('tableComponent pagination settings ', this.paginationSettings);
    this.notify.emit();
    // this.sortNotify.emit();
  }
}
