import { Component, OnInit, Input, Output, EventEmitter } from '@angular/core';
import { NgForm } from '@angular/forms';

@Component({
  selector: 'app-modal',
  template: `
    <div id="modal1" class="modal-overlay" [class.modal-show]="!hidden" [style.visibility]="hidden? 'hidden': 'visible'">
        <div class="modal-content center-align">
            <a class="close" (click)="onModalClose()" tabindex="0">&times;</a>
            <ng-content></ng-content>
        </div>
    </div>
    `,
  styleUrls: ['./modal.component.scss']
})
export class ModalComponent implements OnInit {
  @Input() header = 'formControl';
  @Input() modalTitle = null;
  @Input() hidden = true;
  @Output() modalClosed = new EventEmitter<boolean>();
  modal = 'this is the modal string';

  constructor() {}

  ngOnInit() {}
  onModalClose() {
    this.hidden = true;
    this.modalClosed.emit(this.hidden);
  }
}
