import { Component, OnInit, Input } from '@angular/core';
import {
  SubmissionModel,
  AttachmentModel,
  RelatedRFAIModel
} from './rfai-submission.model';
import { TableService } from './../shared/table/table.service';
import {
  TableColumnModel,
  TableSettings,
  PaginationSettings
} from './../shared/table/table.component.model';
import { RfaiSubmissionService } from './rfai-submission.service';
import { RfaiLookupService } from './../rfai-lookup/rfai-lookup.service';
import { FormBuilder, Validators, FormGroup } from '@angular/forms';

@Component({
  selector: 'app-rfai-submission',
  templateUrl: './rfai-submission.component.html',
  styleUrls: ['./rfai-submission.component.scss']
})
export class RfaiSubmissionComponent implements OnInit {
  @Input() submissionId = '123456';
  model: SubmissionModel = new SubmissionModel();
  attachments: AttachmentModel[] = [];
  showUpdate = true;
  // Initial Values for the dropdown
  healthCareClaimStatusCodeDisplay = [
    'R0   General Requests-Requests that do not fall into other R-type categories',
    'R1   Entity Requests-Requests for information about specific entities',
    'R3   Claim/Line-Requests for information that could normally be submitted on a claim',
    'R4   Documentation-Requests for additional supporting documentation',
    'R5   More specific/detailed information is requested',
    'R6   Regulatory requirements',
    'R7   Confirm care is consistent with Health Plan policy coverage',
    'R8   Confirm care is consistent with health plan coverage exceptions',
    'R9   Determination of medical necessity',
    'R10  Support a filed grievance or appeal',
    'R11  Pre-payment review of claims',
    'R12  Clarification or justification of use for specified procedure code',
    'R13  Original documents submitted are not readable',
    'R14  Original documents received are not what was requested',
    'R15  Workers Compensation coverage determination',
    'R16  Eligibility determination',
    'R17  Replacement of a Prior Request'
  ];
  healthCareClaimStatusCodeValues = [
    'R0',
    'R1',
    'R3',
    'R4',
    'R5',
    'R6',
    'R7',
    'R8',
    'R9',
    'R10',
    'R11',
    'R12',
    'R13',
    'R14',
    'R15',
    'R16',
    'R17'
  ];
  loincCodeDisplay = [
    '34133-9	Continuity of Care Document',
    '11488-4	Consultation Note',
    '18748-4	Diagnostic Imaging Study',
    '18842-5	Discharge Summary',
    '34117-2	History and Physical Note',
    '11504-8	Provider-unspecified Operative Note',
    '28570-0	Provider-unspecified Procedure Note',
    '11506-3	Provider-unspecified Progress Note'
  ];
  loincCodeValues = [
    '34133-9',
    '11488-4',
    '18748-4',
    '18842-5',
    '34117-2',
    '11504-8',
    '28570-0',
    '11506-3'
  ];
  loincCodeModifierDisplay = [
    '18789-8	Include data of selected type within the date window associated with the service.',
    '18790-6	Include data of selected type on or before the date of service.',
    '18791-4	Include data of selected type within or aligned to a service.',
    '18792-2	Include data of selected type on or after the date of service.',
    '18803-7	Include data of selected type that represents observations made 30 days or fewer before the starting date of service.',
    '18804-5	Include data of selected type that represents observations made three months or fewer before the starting date of service.',
    '18805-2	Include data of selected type that represents observations made six months or fewer before the starting date of service.',
    '18806-0	Include data of selected type that represents observations made nine months or fewer before the starting date of service.',
    '18807-8	Include data of selected type that represents observations made one year or less before the starting date of service.',
    '53033-7	Include data of selected type that represents observations made two years or less before the starting date of service.',
    '18793-0	Use no fixed time limit on data—any of the selected type are relevant no matter when obtained.',
    '18794-8	Send all items of the specified type within the time window.',
    '18795-5	Send all items of the specified type within the time window relevant to the service.',
    '18796-3	Send all abnormals within the time window.',
    '18797-1	Send the first abnormals within the time window.',
    '18798-9	Send the last abnormals within the time window.',
    '18800-3	Send the worst abnormal result for each kind of observation in the time window.',
    '18799-7	Send the first (oldest) result for each kind of observation in the time window.',
    '18802-9	Send the last (most recent) within the time window.'
  ];
  loincCodeModifierValues = [
    '18789-8',
    '18790-6',
    '18791-4',
    '18792-2',
    '18803-7',
    '18804-5',
    '18805-2',
    '18806-0',
    '18807-8',
    '53033-7',
    '18793-0',
    '18794-8',
    '18795-5',
    '18796-3',
    '18797-1',
    '18798-9',
    '18800-3',
    '18799-7',
    '18802-9'
  ];

  rfaiStatusValues = [
    'Pending Response',
    'Error',
    'Complete',
    'Abandoned',
    'Closed'
  ];
  // table setup
  tableColumns: TableColumnModel[] = [
    new TableColumnModel('Submission ID', 'submissionId'),
    new TableColumnModel('PDI / Claim ID', 'pdiClaimId'),
    new TableColumnModel('Billing Provider Name', 'providerName'),
    new TableColumnModel('Provider NPI', 'providerNpi'),
    new TableColumnModel('Provider TIN', 'providerTin'),
    new TableColumnModel('Patient Name', 'patientName'),
    new TableColumnModel('Patient ID', 'patientId'),
    new TableColumnModel('Patient Control', 'patientControlNumber'),
    new TableColumnModel('Medical Record', 'medicalRecordNumber'),
    new TableColumnModel('Start Date', 'startDate'),
    new TableColumnModel('End Date', 'endDate')
  ];
  tableSettings: TableSettings = new TableSettings();
  paginationSettings: PaginationSettings = new PaginationSettings();
  relatedRFAIs: RelatedRFAIModel[] = [];
  form: FormGroup;
  // end of table setup
  constructor(
    private fb: FormBuilder,
    private rfaiSubmissionService: RfaiSubmissionService,
    private rfaiLookupService: RfaiLookupService
  ) {}

  ngOnInit() {
    // Remove Later
    this.attachments = [
      {
        hccscCode: 'R0',
        loincCode: '34133-9',
        loincModifier: '18789-8',
        level: 'Claim',
        attachmentStatus: 'Received'
      },
      {
        hccscCode: 'R1',
        loincCode: '3412133-9',
        loincModifier: '58789-8',
        level: 'Claim',
        attachmentStatus: 'Not Received'
      }
    ];

    this.relatedRFAIs = [
      {
        startDate: '01/01/2018 ',
        endDate: '01/31/2018 ',
        medicalRecordNumber: '873432413436',
        patientControlNumber: '9785561212',
        patientId: '45454545 ',
        patientName: 'Indiana Jones',
        pdiClaimId: 2017123456789,
        providerName: 'GOVT GENERAL HOSPITAL',
        providerNpi: '123484454',
        providerTin: '56212121 ',
        status: 'Received',
        submissionId: '166'
      },
      {
        startDate: '01/01/2019 ',
        endDate: '01/03/2018 ',
        medicalRecordNumber: '656565',
        patientControlNumber: '8984844',
        patientId: '91212121',
        patientName: 'Sarah Connor',
        pdiClaimId: 2017123456789,
        providerName: 'GOVT  HOSPITAL',
        providerNpi: '123484454',
        providerTin: '56212121 ',
        status: 'Not Received',
        submissionId: '163'
      }
    ];
    // table Settings
    this.tableSettings.rowNumberDisplay = false;
    this.tableSettings.checkBoxesShow = false;
    this.tableSettings.buttonShow = false;
    this.tableSettings.linkColumn = false;
    this.tableSettings.imgColumn = false;
    this.tableSettings.imageUrls = [];
    this.tableSettings.imageColumnNames = [];
    this.paginationSettings = {
      currentPage: 1,
      pageSize: 10,
      totalPages: 1,
      totalResults: 2,
      sortColumn: 'pdiClaimId',
      descending: false
    };
    this.submissionId = this.getId();
    console.log('submisssion ID', this.submissionId);
    this.getDetails(this.submissionId);
    this.formInit();
  }
  formInit() {
    this.form = this.fb.group({
      responseDate: [
        this.model.responseDate,
        Validators.pattern(
          '(0[1-9]|1[012])[/](0[1-9]|[12][0-9]|3[01])[/](19|20)\\d\\d'
        )
      ],
      status: [this.model.status]
    });
  }
  updateTable() {}
  getId(): string {
    return this.rfaiLookupService.getSubmissionId();
  }
  getDetails(id) {
    this.rfaiSubmissionService.getDetails(id).subscribe(data => {
      this.model = data;
    });
  }
  saveUpdates() {
    console.log('save');
    this.showUpdate = !this.showUpdate;
  }
  print() {
    console.log('print');
  }
  update() {
    console.log('update');
    this.showUpdate = !this.showUpdate;
  }
}
