import { Injectable } from '@angular/core';
import { Observable } from 'rxjs/Observable';
import { Response, Http } from '@angular/http';
import 'rxjs/add/operator/map';
import { PrimarySearchModel, AdvancedSearchModel } from './rfai-lookup.model';

import { environment } from '../../environments/environment';

@Injectable()
export class RfaiLookupService {
  constructor(private http: Http) {}
  submissionId = '';
  advancedSearch(body: AdvancedSearchModel) {
    return this.http
      .post(`${environment.nodeserver}/lookup/search`, body)
      .map((data: Response) => data.json());
  }

  quickSearch(body: PrimarySearchModel) {
    return this.http
      .post(`${environment.nodeserver}/lookup/search`, body)
      .map((data: Response) => data.json());
  }

  getSubmissionId() {
    return this.submissionId;
  }
  setSubmissionId(id) {
    this.submissionId = id;
  }
}
