import { FormBuilder } from '@angular/forms';
import { ElementRef } from '@angular/core';
import { Observable } from 'rxjs/Observable';

import { RfaiLookupComponent } from './rfai-lookup.component';
import { RfaiLookupService } from './rfai-lookup.service';
import { RfaiFormComponent } from '../rfai-form/rfai-form.component';
import { ScriptService } from './../shared/scriptLoader/script.service';
import { TableService } from './../shared/table/table.service';

describe('RfaiLookupComponent', () => {
  // instantianting component
  let component: RfaiLookupComponent;
  let rfaiLookupService: RfaiLookupService;
  let tableService: TableService;
  const script = new ScriptService();
  const fb = new FormBuilder();
  beforeEach(() => {
    rfaiLookupService = new RfaiLookupService(null);
    tableService = new TableService();
    component = new RfaiLookupComponent(
      fb,
      script,
      rfaiLookupService,
      tableService
    );
  });
  it('should be created', () => {
    expect(component).toBeTruthy();
  });
  it('should check if primaryForm has been initialized', () => {
    component.formInit();
    expect(component.primaryForm).toBeDefined();
  });
  it('should check if advancedForm has been initialized', () => {
    component.formInit();
    expect(component.advancedForm).toBeDefined();
  });
  it('should check component initialization', () => {
    const ngOnInitSpy = spyOn(component, 'ngOnInit').and.callFake(() => {});
    component.ngOnInit();
    expect(ngOnInitSpy).toHaveBeenCalled();
  });
  it('should check primarySearch method', () => {
    component.formInit();
    component.primaryForm.get('primarySearchParam').setValue('123456');
    const primarySearchSpy = spyOn(
      rfaiLookupService,
      'quickSearch'
    ).and.callFake(() => {
      return new Observable(observer =>
        observer.next({
          response: [
            {
              pdiClaimId: component.primaryForm.get('primarySearchParam').value
            }
          ]
        })
      );
    });
    component.primarySearch();
    expect(component.searchResults[0].pdiClaimId).toContain('123456');
  });
  it('should clear primary search', () => {
    component.formInit();
    component.primaryForm.get('primarySearchParam').setValue('123456');
    component.clearPrimary();
    expect(component.primaryForm.get('primarySearchParam').value).toBeFalsy();
  });
  it('should check advancedSearch method', () => {
    component.formInit();
    component.advancedForm.get('pdiClaimId').setValue(12345);
    const advancedSearchSpy = spyOn(
      rfaiLookupService,
      'advancedSearch'
    ).and.callFake(() => {
      return new Observable(observer =>
        observer.next({
          response: [
            {
              pdiClaimId: component.advancedForm.get('pdiClaimId').value
            }
          ]
        })
      );
    });
    component.advancedSearch();
    expect(component.searchResults[0].pdiClaimId).toBe(12345);
  });
  it('should clear advanced search', () => {
    component.formInit();
    component.advancedForm.get('pdiClaimId').setValue(12345);
    component.clearAdvancedForm();
    expect(component.advancedForm.get('pdiClaimId').value).toBeFalsy();
  });
  // test validators on advanced search form.
  it('should validate pdiClaimId', () => {
    component.formInit();
    component.advancedForm.get('pdiClaimId').setValue(123);
    expect(component.advancedForm.get('pdiClaimId').valid).toBeTruthy();
  });
  it('should validate providerNpi', () => {
    component.formInit();
    component.advancedForm.get('providerNpi').setValue(123);
    expect(component.advancedForm.get('providerNpi').valid).toBeTruthy();
  });
  it('should validate providerTin', () => {
    component.formInit();
    component.advancedForm.get('providerTin').setValue(123);
    expect(component.advancedForm.get('providerTin').valid).toBeTruthy();
  });
  it('should validate patientIdentifier', () => {
    component.formInit();
    component.advancedForm.get('patientIdentifier').setValue(123);
    expect(component.advancedForm.get('patientIdentifier').valid).toBeTruthy();
  });
  it('should validate patientcontrolNumber', () => {
    component.formInit();
    component.advancedForm.get('patientcontrolNumber').setValue(123);
    expect(
      component.advancedForm.get('patientcontrolNumber').valid
    ).toBeTruthy();
  });
  it('should validate medicalRecordNumber', () => {
    component.formInit();
    component.advancedForm.get('medicalRecordNumber').setValue(123);
    expect(
      component.advancedForm.get('medicalRecordNumber').valid
    ).toBeTruthy();
  });
  // it('should validate lineItemControlNumber', () => {
  //   component.formInit();
  //   component.advancedForm.get('lineItemControlNumber').setValue(123);
  //   expect(
  //     component.advancedForm.get('lineItemControlNumber').valid
  //   ).toBeTruthy();
  // });
  it('should validate serviceStartDate', () => {
    component.formInit();
    component.advancedForm.get('serviceStartDate').setValue('12/12/2017');
    expect(component.advancedForm.get('serviceStartDate').valid).toBeTruthy();
  });
  it('should validate serviceEndDate', () => {
    component.formInit();
    component.advancedForm.get('serviceEndDate').setValue('12/12/2017');
    expect(component.advancedForm.get('serviceEndDate').valid).toBeTruthy();
  });
  // test to clear forms if user toggles between quick/advanced search. // method not working****
  it('should clear primary search if user toggles to advanced search', () => {
    component.formInit();
    component.primaryForm.get('primarySearchParam').setValue('123456');
    component.primaryDiv.nativeElement = { style: { display: 'block' } };
    component.advancedDiv.nativeElement = { style: { display: 'block' } };
    component.showAdvanced();
    expect(component.primaryForm.get('primarySearchParam').value).toBeFalsy();
  });
  it('should clear advanced search if user toggles to quick search', () => {
    component.formInit();
    component.advancedForm.get('pdiClaimId').setValue(12345);
    component.primaryDiv.nativeElement = { style: { display: 'block' } };
    component.advancedDiv.nativeElement = { style: { display: 'block' } };
    component.showPrimary();
    expect(component.advancedForm.get('pdiClaimId').value).toBeFalsy();
  });
  // test validation on date range
  it('should test for valid date ranges', () => {
    component.formInit();
    component.serviceStartDate.nativeElement = { value: '10/10/2011' };
    component.serviceEndDate.nativeElement = { value: '10/10/2012' };
    component.datesValidator();

    expect(component.validDateRange).toBeTruthy();
  });
  // test update table method
  it('should test updateTable with primarySearch being called', () => {
    component.typeOfSearch = 'P';
    const primarySearchSpy = spyOn(component, 'primarySearch');
    component.updateTable();
    expect(primarySearchSpy).toHaveBeenCalled();
  });
  it('should test updateTable with advancedSearch being called', () => {
    component.typeOfSearch = 'A';
    const advancedSearchSpy = spyOn(component, 'advancedSearch');
    component.updateTable();
    expect(advancedSearchSpy).toHaveBeenCalled();
  });
});
