import { RfaiFormComponent } from './rfai-form.component';
import { RfaiFormService } from './rfai-form.service';
import { FormBuilder } from '@angular/forms';
import { ElementRef } from '@angular/core';

import { ScriptService } from './../shared/scriptLoader/script.service';
import {
  AdditionalInformationRequestModel,
  PDIInfoModel,
  LineModel,
  RfaiInfoModel
} from './rfai-form.model';
import { Observable } from 'rxjs/Observable';

describe('RfaiAdditionalInformationComponent', () => {
  let rfaiAdditionalInformationService: RfaiFormService;
  let component: RfaiFormComponent;
  let fb: FormBuilder;
  let script: ScriptService;
  beforeEach(() => {
    rfaiAdditionalInformationService = new RfaiFormService(null);
    fb = new FormBuilder();
    script = new ScriptService();
    component = new RfaiFormComponent(
      fb,
      rfaiAdditionalInformationService,
      script
    );
  });
  it('RfaiAdditionalInformationComponent should have been created', () => {
    expect(component).toBeTruthy();
  });
  it('should successfully run ngOnInit', () => {
    const ngOnInitSpy = spyOn(component, 'ngOnInit');
    component.ngOnInit();
    expect(ngOnInitSpy).toHaveBeenCalled();
  });
  it('form should have been initialized', () => {
    component.ngOnInit();
    const formSpy = spyOn(component, 'formInit');
    expect(component.form).toBeTruthy();
  });

  // INVALID
  it('should pass falsy value into claimStatus and be invalid', () => {
    component.ngOnInit();
    const formSpy = spyOn(component, 'formInit');
    component.form.get('claimStatus').setValue('');
    expect(component.form.get('claimStatus').invalid).toBeTruthy();
  });
  it('should pass falsy value into loincCode and be invalid', () => {
    component.ngOnInit();
    const formSpy = spyOn(component, 'formInit');
    component.form.get('claimStatus').setValue('');
    expect(component.form.get('claimStatus').invalid).toBeTruthy();
  });
  it('should pass falsy value into loincCodeModifier and be invalid', () => {
    component.ngOnInit();
    const formSpy = spyOn(component, 'formInit');
    component.form.get('claimStatus').setValue('');
    expect(component.form.get('claimStatus').invalid).toBeTruthy();
  });

  // VALID
  it('should pass truthy value into claimStatus and be valid', () => {
    component.ngOnInit();
    const formSpy = spyOn(component, 'formInit');
    component.form.get('claimStatus').setValue('value');
    expect(component.form.get('claimStatus').valid).toBeTruthy();
  });
  it('should pass truthy value into loincCode and be valid', () => {
    component.ngOnInit();
    const formSpy = spyOn(component, 'formInit');
    component.form.get('loincCode').setValue('value');
    expect(component.form.get('loincCode').valid).toBeTruthy();
  });
  it('should pass truthy value into loincCodeModifier and be valid', () => {
    component.ngOnInit();
    const formSpy = spyOn(component, 'formInit');

    component.form.get('loincCodeModifier').setValue('value');
    expect(component.form.get('loincCodeModifier').valid).toBeTruthy();
  });

  // ENTIRE FORM

  it('should pass falsy values into validators, form should be invalid', () => {
    component.ngOnInit();
    const formSpy = spyOn(component, 'formInit');
    component.form.get('claimStatus').setValue('');
    component.form.get('loincCode').setValue('');
    component.form.get('loincCodeModifier').setValue('');
    expect(component.form.invalid).toBeTruthy();
  });

  // it('should pass truthy values into validators, form should be valid', () => {
  //   component.ngOnInit();
  //   const formSpy = spyOn(component, 'formInit');
  //   component.form.get('claimStatus').setValue('value');
  //   component.form.get('loincCode').setValue('value');
  //   component.form.get('loincCodeModifier').setValue('value');
  //   expect(component.form.valid).toBeTruthy();
  // });

  // ONSUBMIT
  it('should test onSubmit if statement', () => {
    component.ngOnInit();
    component.prepopulatedInfo.rfaiLineItemResponse = [new LineModel()];
    component.prepopulatedInfo.rfaiLineItemResponse[0].chargeAmount = 1;
    const formSpy = spyOn(component, 'formInit');
    const serviceSpy = spyOn(
      rfaiAdditionalInformationService,
      'submitRfai'
    ).and.callFake(() => {
      return new Observable(observer => observer.next({ message: 'msg' }));
    });
    component.populateInfoClicked = true;
    component.onSubmit();
    expect(component.lines[0].hasOwnProperty('chargeAmount')).toBeTruthy();
    expect(component.pdiInfoModel).toEqual(component.prepopulatedInfo);
  });

  it('should test onSubmit', () => {
    component.ngOnInit();
    component.prepopulatedInfo.rfaiLineItemResponse = [new LineModel()];
    const formSpy = spyOn(component, 'formInit');
    const serviceSpy = spyOn(
      rfaiAdditionalInformationService,
      'submitRfai'
    ).and.callFake(() => {
      return new Observable(observer =>
        observer.next({
          result: 'value',
          message: 'An error occured during RFAI 277 submission.'
        })
      );
    });
    component.onSubmit();
    expect(component.successMsg).toEqual('RFAI 277 successfully submitted.');
  });

  it('should test onSubmit and get an error message', () => {
    component.ngOnInit();
    component.prepopulatedInfo.rfaiLineItemResponse = [new LineModel()];
    const formSpy = spyOn(component, 'formInit');
    const serviceSpy = spyOn(
      rfaiAdditionalInformationService,
      'submitRfai'
    ).and.callFake(() => {
      return new Observable(observer =>
        observer.next({
          result: '',
          message: 'An error occured during RFAI 277 submission.'
        })
      );
    });
    component.onSubmit();
    expect(component.successMsg).toEqual('');
    expect(component.errorMsg).toEqual(
      'An error occured during RFAI 277 submission.'
    );
  });

  it('should run onSubmit and correctly assign selectedLines', () => {
    component.ngOnInit();

    const formSpy = spyOn(component, 'formInit');
    const serviceSpy = spyOn(
      rfaiAdditionalInformationService,
      'submitRfai'
    ).and.callFake(() => {
      return new Observable(observer =>
        observer.next({ result: '', message: 'this is the error message' })
      );
    });
    component.lines = [new LineModel(), new LineModel(), new LineModel()];
    component.lines[0].selected = true;
    component.onSubmit();
    expect(component.selectedLines.length).toBe(1);
  });

  // onReset method.
  it('should check onReset method', () => {
    component.errorMsg = 'error message';
    component.onReset();
    expect(component.errorMsg).toBeFalsy();
  });

  // addNewLine method.
  it('should check addNewLine method', () => {
    component.enableAddLine = true;
    component.addNewLine();
    expect(component.enableAddLine).toBe(false);
    expect(component.lines.length).toBe(1);
  });

  // populateInfo method.
  it('should check populateInfo method', () => {
    component.model.claimId = 123;
    component.populateInfoClicked = false;
    component.selectAllLines.nativeElement = new ElementRef(
      '<input checked="true" type="checkbox"/>'
    );
    spyOn(rfaiAdditionalInformationService, 'populateInfo').and.callFake(() => {
      return new Observable(observer => observer.next(new PDIInfoModel()));
    });
    component.populateInfo();
    expect(component.populateInfoClicked).toBe(true);
    expect(component.prepopulatedInfo).toEqual(new PDIInfoModel());
    expect(component.selectAllLines.nativeElement.checked).toBe(false);
  });

  // saveLine method.
  it('should check saveLine method', () => {
    component.lines = [new LineModel(), new LineModel()];
    console.log(component.lines);
    component.lines[0].serviceLineId = 123;
    component.saveLine();
    expect(component.lines[0].selected).toBe(true);
  });

  // enableAddLineButton method.
  it('should check enableAddLineButton', () => {
    component.enableAddLine = false;
    component.enableAddLineButton();
    expect(component.enableAddLine).toBe(true);
  });
});
