import { Injectable } from '@angular/core';
import { Observable } from 'rxjs/Observable';
import { Response, Http } from '@angular/http';
import 'rxjs/add/operator/map';

import { environment } from '../../environments/environment';
import { HealthCareClaimStatusModel } from './rfai-admin.model';
@Injectable()
export class RfaiAdminService {
  constructor(private http: Http) {}
  hccscCodes: HealthCareClaimStatusModel[] = [
    {
      code: 'R0',
      description:
        'General Requests-Requests that do not fall into other R-type categories',
      selected: true
    },
    {
      code: 'R1',
      description:
        'Entity Requests-Requests for information about specific entities',
      selected: true
    },
    {
      code: 'R3',
      description:
        'Claim/Line-Requests for information that could normally be submitted on a claim',
      selected: false
    },
    {
      code: 'R4',
      description:
        'Documentation-Requests for additional supporting documentation',
      selected: true
    }
  ];

  getHccscCode() {
    // return this.http
    //   .get(`${environment.nodeserver}/rfai/populateClaim/${id}`)
    //   .map((data: Response) => data.json());

    return Observable.create(observer => {
      observer.next(this.hccscCodes);
    });
  }
}
