import { Component, OnInit } from '@angular/core';
// import { FormBuilder, Validators, FormGroup } from '@angular/forms';

import { RfaiAdminService } from './rfai-admin.service';
import { HealthCareClaimStatusModel } from './rfai-admin.model';
@Component({
  selector: 'app-rfai-admin',
  templateUrl: './rfai-admin.component.html',
  styleUrls: [
    './../rfai-form/rfai-form.component.scss',
    './rfai-admin.component.scss'
  ]
})
export class RfaiAdminComponent implements OnInit {
  modalClosed = true;
  constructor(
    // private fb: FormBuilder,
    private rfaiAdminService: RfaiAdminService
  ) {}
  managementType = 'C';
  healthCodes: HealthCareClaimStatusModel[] = [];
  modalError = false;
  addClicked = false;
  // addHealthCodeForm: FormGroup;
  newHealthCode: HealthCareClaimStatusModel = new HealthCareClaimStatusModel();
  tempHealthCodeObj: HealthCareClaimStatusModel = new HealthCareClaimStatusModel();
  tempNewHealthCodeObj: HealthCareClaimStatusModel = new HealthCareClaimStatusModel();
  ngOnInit() {
    this.getHealthCodes();
    // this.formInit();
  }

  getHealthCodes() {
    this.rfaiAdminService.getHccscCode().subscribe(data => {
      this.healthCodes = data;
    });
  }

  addHealthCode() {
    if (this.tempNewHealthCodeObj.code) {
      this.healthCodes.push(this.tempNewHealthCodeObj);
      this.newHealthCode = new HealthCareClaimStatusModel();
      this.tempNewHealthCodeObj = new HealthCareClaimStatusModel();
      this.modalClosed = true;
      this.modalError = false;
    } else {
      this.modalError = true;
    }
  }

  editHealthCode(
    newHealthCode: HealthCareClaimStatusModel,
    oldHealthCode: HealthCareClaimStatusModel
  ) {
    const indexElement = this.healthCodes.findIndex(
      code => code.code === oldHealthCode.code
    );
    this.healthCodes[indexElement] = newHealthCode;
    this.modalClosed = true;
  }

  openAddModal() {
    this.addClicked = true;
    this.tempNewHealthCodeObj = this.newHealthCode;
    this.onModalOpen();
  }

  openEditModal(healthCodeObj: HealthCareClaimStatusModel) {
    this.addClicked = false;
    this.tempNewHealthCodeObj = { ...healthCodeObj };
    this.tempHealthCodeObj = { ...healthCodeObj };
    this.onModalOpen();
  }
  onModalOpen() {
    this.modalClosed = false;
  }

  onModalClose(bool: boolean) {
    this.modalClosed = bool;
    this.addClicked = false;
  }
  submit() {}
  cancel() {}
}
