import { BrowserModule } from '@angular/platform-browser';
import { NgModule } from '@angular/core';
import { AppRoutingModule } from './app-routing.module';
import { HttpModule } from '@angular/http';
import { AppComponent } from './app.component';
import { LoginComponent } from './login/login.component';
import { RouterModule } from '@angular/router';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { RfaiFormComponent } from './rfai-form/rfai-form.component';
import { RfaiFormService } from './rfai-form/rfai-form.service';
import { RfaiLookupService } from './rfai-lookup/rfai-lookup.service';
import { ModalComponent } from './shared/modal/modal.component';
import { RfaiLookupComponent } from './rfai-lookup/rfai-lookup.component';
import { TableComponent } from './shared/table/table.component';
import { PaginationComponent } from './shared/table/pagination/pagination.component';
import { TableService } from './shared/table/table.service';
import { RfaiSubmissionComponent } from './rfai-submission/rfai-submission.component';
import { RfaiSubmissionService } from './rfai-submission/rfai-submission.service';
import { RfaiAdminComponent } from './rfai-admin/rfai-admin.component';
import { RfaiAdminService } from './rfai-admin/rfai-admin.service';
@NgModule({
  declarations: [
    AppComponent,
    LoginComponent,
    ModalComponent,
    RfaiFormComponent,
    RfaiLookupComponent,
    TableComponent,
    PaginationComponent,
    RfaiSubmissionComponent,
    RfaiAdminComponent
  ],
  imports: [
    BrowserModule,
    FormsModule,
    HttpModule,
    AppRoutingModule,
    RouterModule,
    ReactiveFormsModule
  ],
  providers: [
    RfaiFormService,
    RfaiLookupService,
    TableService,
    RfaiSubmissionService,
    RfaiAdminService
  ],
  bootstrap: [AppComponent]
})
export class AppModule {}
