import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';
import { LoginComponent } from './login/login.component';
import { RfaiFormComponent } from './rfai-form/rfai-form.component';
import { RfaiLookupComponent } from './rfai-lookup/rfai-lookup.component';
import { RfaiSubmissionComponent } from './rfai-submission/rfai-submission.component';
import { RfaiAdminComponent } from './rfai-admin/rfai-admin.component';

const routes: Routes = [
  { path: '', component: LoginComponent, pathMatch: 'full' },
  {
    path: 'additionalInformation',
    component: RfaiFormComponent
  },
  {
    path: 'lookup',
    component: RfaiLookupComponent
  },
  {
    path: 'viewSubmission',
    component: RfaiSubmissionComponent
  },
  {
    path: 'admin',
    component: RfaiAdminComponent
  }
];

@NgModule({
  imports: [RouterModule.forRoot(routes)],
  exports: [RouterModule]
})
export class AppRoutingModule {}
