const express = require('express');
const path = require('path');
const http = require('http');
const bodyParser = require('body-parser');
const app = express();
// Added to read the endPointURI from the properties file
const dotenv = require('dotenv').config();
// Change!!!
app.use(bodyParser.json());
app.use(
  bodyParser.urlencoded({
    extended: false
  })
);
app.use(express.static(path.join(__dirname, './dist')));
// Below is REST Caching fix for IE11
app.use(function(req, res, next) {
  res.set({
    'Access-Control-Allow-Origin': '*',
    'Access-Control-Allow-Methods': 'GET,POST,PUT,DELETE,OPTIONS',
    'Access-Control-Allow-Headers':
      'Origin, X-Requested-With, Content-Type, Accept',
    'Cache-Control': 'no-cache, no-store, private, must-revalidate',
    Expires: '-1',
    Pragma: 'no-cache'
  });
  next();
});

// at this point all we need is the login route
const login = require('./ars-app-server/server/routes/login/login');
const rfai = require('./ars-app-server/server/routes/rfai/rfai');
const lookup = require('./ars-app-server/server/routes/lookup/lookup');
/*

*/
app.use('/login', login);
app.use('/rfai', rfai);
app.use('/lookup', lookup);

const port = process.env.PORT || '3003';
app.set('port', port);
const server = http.createServer(app);

app.get('*', (req, res) => {
  res.sendFile(path.join(__dirname, './dist/index.html'));
});

server.listen(port, () =>
  console.log(
    `API running on localhost:${port} - Using endpoint ` +
      process.env.END_POINT_BASE_URI
  )
);
