const express = require('express');
const router = express.Router();
const rest = require('../../rest/rest');

router.post('/submit', (req, res) => {
  rest
    .postResource(
      process.env.END_POINT_BASE_URI + process.env.ADDITIONAL_INFO,
      req.body
    )
    .then(data => {
      res.status(200).json(data);
    })
    .catch(error => console.log('submit rfai', error));
});

router.get('/populateClaim/:id', (req, res) => {
  const id = req.params.id;
  rest
    .getResource(
      process.env.END_POINT_BASE_URI +
        process.env.POPULATE_CLAIM +
        '/' +
        id +
        '?level=line'
    )
    .then(data => {
      if (data) {
        res.status(200).json(data);
      } else {
        res.status(500).json(data);
      }
    })
    .catch(error => {
      console.log('Reports getStations error ', error);
    });
});
module.exports = router;
