package automation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.junit.Assert;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.Select;
import org.openqa.selenium.support.ui.WebDriverWait;

/***
 * 
 * @author KYibrie, PMohite, CMota,
 * @version 2.0
 */
public class SharedCodeClass extends ExplorerSuite {

  /**
   * This waits for the page to load to continue with the proceeding task.
   *
   */
  public static void waitForLoad(WebDriver driver) {
    ExpectedCondition<Boolean> pageLoadCondition = new ExpectedCondition<Boolean>() {
      @Override
      public Boolean apply(WebDriver driver) {
        return ((JavascriptExecutor) driver).executeScript("return document.readyState").equals("complete");
      }
    };
    WebDriverWait wait = new WebDriverWait(driver, 30);
    wait.until(pageLoadCondition);
  }

  /**
   * This finds all elements by tag.
   *
   * @param tag
   *          String
   * @param thTitles
   *          List of String
   */
  public static void findAllEllementsTag(String tag, List<String> text) {
    List<WebElement> allElements = driver.findElements(By.tagName(tag));
    Iterator<WebElement> itElement = allElements.iterator();
    Iterator<String> itThName = text.iterator();

    while (itElement.hasNext() && itThName.hasNext()) {
      String elementText = itElement.next().getText();
      if(elementText.equals("")){
    	  continue;  
      }    	  
      String  testText=itThName.next();
  //   System.out.println(testText+"-------"+elementText);
      Assert.assertTrue(elementText.equalsIgnoreCase(testText));     
    }
  }

  /**
   * This finds an element by class. It takes on one class at a time
   *
   * @param name
   *          String
   */
  public static void findElementClass(String name) {
    List<WebElement> allElements = driver.findElements(By.className(name));
    for (WebElement element : allElements) {
      Assert.assertTrue(driver.findElement(By.className(name)).getAttribute("innerHTML") != null);
    }
  }

  /**
   * This finds an element by ID. It takes on one ID at a time
   *
   * @param name
   *          String
   */
  public static void findElementId(String name) {

    List<WebElement> allElements = driver.findElements(By.id(name));
    for (WebElement element : allElements) {
      Assert.assertTrue(driver.findElement(By.id(name)).getAttribute("innerHTML") != null);
    }
  }

  /**
   * Assert class's, one class or multiple
   *
   * @param className
   *          List of String
   */
  public static void assertByClass(ArrayList<String> className) {
    for (String id : className) {
      for (WebElement element : driver.findElements(By.className(id))) {
        Assert.assertTrue(driver.findElement(By.className(id)).getAttribute("innerHTML") != null);
      }
    }
  }

  /**
   * Assert class's, one ID or multiple
   *
   * @param name
   *          List of String
   */
  public static void assertById(ArrayList<String> name) {
    for (String id : name) {
    //	System.out.println(driver.findElements(By.id(id)));
      for (WebElement element : driver.findElements(By.id(id))) {
        Assert.assertTrue(driver.findElement(By.id(id)).getAttribute("innerHTML") != null);
      }
    }

  }

  /**
   * Assert text inside of an ID
   *
   * @param elements
   *          Map of elements
   */
  public static void assertByTextById(Map<String, String> elements) {
    for (Map.Entry<String, String> id : elements.entrySet()) {
      for (WebElement element : driver.findElements(By.id(id.getKey()))) {
        if (element.getText().trim().length() > 0) {
          // System.out.printf("%s \n", element.getText());//, id.getValue());
          Assert.assertTrue(element.getText().equals(id.getValue()));
        }
      }
    }
  }

  /**
   * Assert text inside of an Class
   *
   * @param elements
   *          Map of elements
   */
  public static void assertByTextByClass(Map<String, String> elements) {
    for (Map.Entry<String, String> className : elements.entrySet()) {
      for (WebElement element : driver.findElements(By.className(className.getKey()))) {
        Assert.assertTrue(element.getText().equals(className.getValue()));
      }
    }
  }

  /**
   * Give an ID and it will fill in the text
   *
   * @param id
   *          String
   * @param text
   *          Text to fill
   */
  public static void fillElementById(String id, String text) {
    // for (Map.Entry<String, String> id : elements.entrySet()) {
    driver.findElement(By.id(id)).sendKeys(text);
    // }
  }

  /**
   * Give an ID and it will fill in the text
   *
   * @param id
   *          String
   * @param text
   *          Text to fill
   */
  public static void fillAllElementById(String id, String text) throws Exception {
    List<WebElement> allElements = driver.findElements(By.id(id));
    for (WebElement element : allElements) {
      element.sendKeys(text);
    }
  }

  /**
   * Give a Class and it will fill in the text
   *
   * @param className
   *          String
   * @param text
   *          Text to fill
   */
  public static void fillElementByClassName(String className, String text) {
    driver.findElement(By.className(className)).sendKeys(text);
  }

  /**
   * Give multiple class names and it will fill in the text
   *
   * @param className
   *          String
   * @param text
   *          Text to fill
   */
  public static void fillAllElemenstByClassName(String className, String text) throws Exception {
    List<WebElement> allElements = driver.findElements(By.className(className));
    for (WebElement element : allElements) {
   //   System.out.println(element);
      element.sendKeys(text);
    }
  }

  /**
   * Give multiple class names and it will fill in the text
   *
   * @param className
   *          String
   * @param text
   *          Text to fill
   */
  public static void clickById(String id) {
    driver.findElement(By.id(id)).click();
  }

  public static void setDropDown(String id, String text) throws InterruptedException {
    Select dropdown = new Select(driver.findElement(By.id(id)));
    dropdown.selectByVisibleText(text);
//    Thread.sleep(1000);
    driver.findElement(By.id("loginAdminBtn")).click();
  }
  
  /**
   * Give an attribute to search for and the value within it
   *
   * @param attribute
   *          String attribute to search for example id, alt, value
   * @param value
   *          String of the attribute contents
   */
  public static void universalSelector(String attribute, String value){
	  waitForLoad(driver);
	  driver.findElement(By.cssSelector("" + attribute + "[alt=" + value.trim() +  "]")).click();
	  
  }

}
