package automation.Pages;

import java.util.ArrayList;

import org.junit.Test;

import automation.ExplorerSuite;
import automation.SharedCodeClass;

public class RfaiAdditionalInfoTest extends ExplorerSuite {
	
	@Test
	public void localRunner(){
		driver.get(baseUrl + "additionalInformation");
		SharedCodeClass.waitForLoad(driver);
		topData();
		claimInfoData();
		lineLevel();
		
	}
	
	@Test
	public void topData(){
		ArrayList<String> topData = new ArrayList<String>();
		topData.add("pdiClaimId");
		topData.add("healthCareClaimStatusCode");
		topData.add("loincCode");
		topData.add("loincCodeModifier");
		SharedCodeClass.assertById(topData);
	}
	
	@Test
	public void claimInfoData(){
		
		ArrayList<String> claimInfo = new ArrayList<String>();
		claimInfo.add("payerName");
		claimInfo.add("payerID");
		claimInfo.add("informationReceiver");
		claimInfo.add("responseDueDate" );
		claimInfo.add("contactInfo");
		claimInfo.add("billingProvider");
		claimInfo.add("providerNpi");
		claimInfo.add("serviceProviderTIN");
		claimInfo.add("lastName" );
		claimInfo.add("firstName");
		claimInfo.add("patientID");
		claimInfo.add("patientControlNumber");
		claimInfo.add("payerClaimControlNumber" );
		claimInfo.add("billType");
		claimInfo.add("clearingHouseID");
		claimInfo.add("medicalRecordNumber");
		SharedCodeClass.assertById(claimInfo);
	}
	
	
	@Test
	public void lineLevel(){
	//	System.out.println("Line Level test");
		SharedCodeClass.clickById("lineLevel");
		ArrayList<String> lineInfo = new ArrayList<String>();
		lineInfo.add("Service Line");
		lineInfo.add("Service From");
		lineInfo.add("Service To");
		lineInfo.add("Revenue Code");
		lineInfo.add("Procedure Code");
		lineInfo.add("Modifiers");
		lineInfo.add("Charge Amount");
		SharedCodeClass.findAllEllementsTag("th", lineInfo);
	}
}
