package gov.va.med.ars.validators;

import java.util.InputMismatchException;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;

import gov.va.med.ars.constants.ErrorMessages;
import gov.va.med.ars.exceptions.GenericException;

/**
 * @author Vamsi Krishna Gangarapu
 *
 */
public class ClaimNumberValidator {

	private static final Logger logger = LogManager.getLogger(ClaimNumberValidator.class);

	/**
	 * @param claimIndex
	 * @return boolean value
	 * @throws GenericException
	 */
	public Boolean returnClaimNumber(String claimIndex) throws GenericException {
		Boolean isValid = false;
		try {
			if (claimIndex.matches("[0-9]+")) {
				//claimNumber = Long.valueOf(claimIndex).longValue();
				isValid = true;
				return isValid;
			} else {
				throw new GenericException(ErrorMessages.BAD_REQUEST, "Not a valid Claim Number", HttpStatus.BAD_REQUEST);
			}

		} catch (InputMismatchException  e) {
			logger.error("ClaimDetailsServiceImpl.getClaimDetailsByClaimIndex() internal_server_error for " + claimIndex
					+ " " + e);
			throw new GenericException(ErrorMessages.BAD_REQUEST, e.getMessage(), HttpStatus.BAD_REQUEST);
		}
	}

}
