package gov.va.med.ars.service.impl;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.fasterxml.jackson.annotation.JsonInclude;

import gov.va.med.ars.dao.ars.ClaimSubmissionRepository;
import gov.va.med.ars.dao.ars.HccsCdRepository;
import gov.va.med.ars.dao.ars.LoincCdRepository;
import gov.va.med.ars.dao.ars.LoincModCdRepository;
import gov.va.med.ars.dao.ars.RfaiLookupRepository;
import gov.va.med.ars.exceptions.GenericException;
import gov.va.med.ars.model.response.RfaiRelatedItemResponse;
import gov.va.med.ars.model.response.RfaiSubmissionResponse;
import gov.va.med.ars.service.IRfaiSubmissionService;
import gov.va.med.domain.ars.ClaimSubmission;
import gov.va.med.domain.ars.HccsCd;
import gov.va.med.domain.ars.LoincCd;
import gov.va.med.domain.ars.LoincModCd;

@Service
public class RfaiSubmissionServiceImpl implements IRfaiSubmissionService {

	DateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
	
	@Autowired
	ClaimSubmissionRepository claimSubRepo;
	
	@Autowired
	HccsCdRepository hccsRepo;
	
	@Autowired
	LoincCdRepository loincRepo;
	
	@Autowired
	LoincModCdRepository loincModRepo;
	
	@Autowired
	RfaiLookupRepository rfaiRepository;
	
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private Long claimId;
	
	@Override
	public RfaiSubmissionResponse getRfaiSubmissionResults(Long submissionId) throws GenericException {
		RfaiSubmissionResponse rfaiResponse = new RfaiSubmissionResponse();

		ClaimSubmission claimSubmission = rfaiRepository.findOne(submissionId);
		List<String> hccsCds = new ArrayList<String>();
		List<String> loincCds = new ArrayList<String>();
		List<String> loincModCds = new ArrayList<String>();
		HccsCd hccsCd = hccsRepo.findOne(claimSubmission.getHccsCd().getHccsId());
		hccsCds.add(hccsCd.getStchccstatuscatCd());
		LoincCd loincCd = loincRepo.findOne(claimSubmission.getLoincCd().getLoincId());
		loincCds.add(loincCd.getStcloincCd());
		LoincModCd loincModCd = loincModRepo.findOne(claimSubmission.getLoincModCd().getLoincModId());
		loincModCds.add(loincModCd.getStcloincCdMod());
		List<ClaimSubmission> relatedSubmissions = (List<ClaimSubmission>) rfaiRepository.findBytrn02fppsClaimId(claimSubmission.getTrn02fppsClaimId());
		List<RfaiRelatedItemResponse> rfaiRelatedItemResponses = new ArrayList<RfaiRelatedItemResponse>();
		for(ClaimSubmission cs : relatedSubmissions) {
			if(cs.getSubmissionid() != claimSubmission.getSubmissionid()) {
				RfaiRelatedItemResponse rfaiRelatedItemResponse = new RfaiRelatedItemResponse();
				rfaiRelatedItemResponse.setClaimId(cs.getTrn02fppsClaimId());
				if(cs.getDtp103svctodt() != null) {
					rfaiRelatedItemResponse.setEndDate(cs.getDtp103svctodt().toString());
				}
				rfaiRelatedItemResponse.setMedicalRecordNumber(cs.getRef302medrecnmbr());
				rfaiRelatedItemResponse.setPatientControlNumber(cs.getRef102ptctrlnmbr());
				rfaiRelatedItemResponse.setPatientId(cs.getHl4nm109ptid());
				rfaiRelatedItemResponse.setPatientName(cs.getHl4nm103ptlstnm() + "," + cs.getHl4nm104ptftnm());
				rfaiRelatedItemResponse.setProviderNPI(cs.getHl3nm109prvnpi());
				rfaiRelatedItemResponse.setProviderTin(cs.getHl2nm109svcprvtin());
				if(cs.getDtp103svcfrmdt() != null) {
					rfaiRelatedItemResponse.setStartDate(cs.getDtp103svcfrmdt().toString());
				}
				rfaiRelatedItemResponse.setSubmissionId(submissionId);
				rfaiRelatedItemResponses.add(rfaiRelatedItemResponse);
			}
		}
		Long submissionLong = claimSubmission.getSubmissionid();
		if(submissionLong != null) {
			rfaiResponse.setPayerName(claimSubmission.getHl1nm103pyrNm());
			rfaiResponse.setPayerId(claimSubmission.getHl1nm109pyrId());
			rfaiResponse.setInformationReceiver(claimSubmission.getHl2nm103infRcvr());
			if(claimSubmission.getDtp203responseduedate() != null) {
				rfaiResponse.setResponseDate(claimSubmission.getDtp203responseduedate().toString());
			}
			rfaiResponse.setBillingProvider(claimSubmission.getHl3nm103svcbillprvnm());
			rfaiResponse.setProviderNpi(claimSubmission.getHl3nm109prvnpi());
			rfaiResponse.setProviderTin(claimSubmission.getHl2nm109svcprvtin());
			rfaiResponse.setPatientLastname(claimSubmission.getHl4nm103ptlstnm());
			rfaiResponse.setPatientFirstName(claimSubmission.getHl4nm104ptftnm());
			rfaiResponse.setPatientIdentifier(claimSubmission.getHl4nm109ptid());
			rfaiResponse.setPatientcontrolNumber(claimSubmission.getRef102ptctrlnmbr());
			rfaiResponse.setPayerClaimControlNumber(claimSubmission.getTrn02pyrclmctrlnmbr());	
			rfaiResponse.setBillType(claimSubmission.getRef202billtype());
			rfaiResponse.setClaimId(claimSubmission.getTrn02fppsClaimId());
			rfaiResponse.setClearingHouseId(claimSubmission.getRef402clrnghsid());
			rfaiResponse.setMedicalRecordNumber(claimSubmission.getRef302medrecnmbr());
			rfaiResponse.setRfaiRelatedItemResponse(rfaiRelatedItemResponses);
			if(claimSubmission.getDatesubmitted() !=  null) {
				rfaiResponse.setRfaiSubmissionDate(claimSubmission.getDatesubmitted().toString());
			}
			rfaiResponse.setRfaiStatus(claimSubmission.getGenerate277Status());
			rfaiResponse.setStatusCode(hccsCds);
			rfaiResponse.setLoincCodes(loincCds);
			rfaiResponse.setLoincModCodes(loincModCds);
			rfaiResponse.setClaimLevel("");
			rfaiResponse.setAttachments("");
		}
		return rfaiResponse;
	}	
}