/**
 * 
 */
package gov.va.med.ars.service.impl;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import gov.va.med.ars.constants.ErrorMessages;
import gov.va.med.ars.dao.erepos.IRfaiEreposRepository;
import gov.va.med.ars.dao.ewv.IRfaiEwvRepository;
import gov.va.med.ars.dao.fpps.IRfaiFppsClaimRepository;
import gov.va.med.ars.errorhandling.ValidationMessage;
import gov.va.med.ars.exceptions.EntityNotFoundException;
import gov.va.med.ars.exceptions.GenericException;
import gov.va.med.ars.exceptions.ValidationException;
import gov.va.med.ars.model.response.RfaiLineItemResponse;
import gov.va.med.ars.model.response.RfaiResponse;
import gov.va.med.ars.service.IRfaiService;
import gov.va.med.domain.ereposModel.EntityAdtlId;
import gov.va.med.domain.ereposModel.EntityName;
import gov.va.med.domain.ewv.EwvClaims;
import gov.va.med.domain.ewv.EwvServiceLines;
import gov.va.med.domain.fee.Claim;
import gov.va.med.domain.fee.ClaimProcedure;
import gov.va.med.domain.fee.PersonInfo;
import gov.va.med.domain.fee.ProviderInfo;

/**
 * @author DNS   AI
 *
 */
@Service
public class RfaiServiceImpl implements IRfaiService {

	private static final Logger logger = LogManager.getLogger(RfaiServiceImpl.class);

	@Autowired
	IRfaiFppsClaimRepository rfaiFppsRepository;

	@Autowired
	IRfaiEreposRepository rfaiEreposRepository;

	@Autowired
	IRfaiEwvRepository rfaiEwvRepository;

	DateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");

	public final String ewvPayerId = "84146";
	public final String fppsPayerId = "12115";
	public final String payerName = "Veteran's Affairs";

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.ars.service.IRfaiService#populateRfaiInfo(java.lang.Long,
	 * java.lang.String)
	 */
	@Override
	public RfaiResponse populateRfaiInfo(Long id)
			throws ValidationException, GenericException, EntityNotFoundException {
		logger.info("In RfaiServiceImpl");
		RfaiResponse rfaiResponseResult = null;
		// RfaiResponse rfaiResponseResult = null;
		List<ValidationMessage> validationMessages = new ArrayList<>();
		List<gov.va.med.domain.ereposModel.Claim> eReposClaimInfo = null;
		boolean status = true;
		String idNumber = String.valueOf(id);
		try {
			if (idNumber.length() <= 15) {
				if (String.valueOf(id).length() == 15) {
					if (Integer.valueOf(idNumber.substring(4, 7)) <= 366 && checkclaimType(idNumber.substring(7, 9))) {

						logger.info(" getEwvPdiInfo() : getting the PDI information from EWV");
						EwvClaims ewvClaimsInfo = rfaiEwvRepository.getEwvPdiInfo(idNumber);
						logger.debug("getEwvPdiInfo() : PDI information from EWV" + valueOf(ewvClaimsInfo));
						logger.info(" getEreposClaimInformation() : getting the PDI information from ERepos");
						if (ewvClaimsInfo != null) {
							eReposClaimInfo = rfaiEreposRepository
									.getEreposClaimInformation(ewvClaimsInfo.getEdiClaimKey());
							logger.debug("getEreposClaimInformation() : PDI information from Erepos"
									+ valueOf(eReposClaimInfo));
							rfaiResponseResult = getPdiClaimInformation(ewvClaimsInfo, eReposClaimInfo, id);

							logger.info(" Claim is selected. So, returning the Claim information");
							logger.debug("Claim information " + valueOf(rfaiResponseResult));
							rfaiResponseResult = addPdiLineItemInformation(ewvClaimsInfo, rfaiResponseResult);
						} else {
							logger.error("RfaiServiceImpl.populateRfaiInfo() : exception occured for " + id);
							throw new GenericException(ErrorMessages.NOT_FOUND, "Enter a valid number",
									HttpStatus.NOT_FOUND);
						}
					} else {
						logger.error("RfaiServiceImpl.populateRfaiInfo() : exception occured for " + id);
						throw new GenericException(ErrorMessages.NOT_FOUND, "Enter a valid number",
								HttpStatus.NOT_FOUND);
					}
				} else {
					logger.info(" getClaimInformation() : getting the Claim information from FPPS");
					Claim claimInfo = rfaiFppsRepository.getClaimInformation(id);
					logger.debug("getClaimInformation() : Claim information from FPPS" + valueOf(claimInfo));
					logger.info(" getEreposClaimInformation() : getting the Claim information from ERepos");
					if (claimInfo != null) {
						eReposClaimInfo = rfaiEreposRepository.getEreposClaimInformation(claimInfo.getEdiClaimKey());
						logger.debug("getEreposClaimInformation() : Claim information from ERepos "
								+ valueOf(eReposClaimInfo));
						rfaiResponseResult = getClaimIdClaimInformation(claimInfo, eReposClaimInfo, id);
						rfaiResponseResult = addClaimLineItemInformation(claimInfo, rfaiResponseResult);
					} else {
						logger.error("RfaiServiceImpl.populateRfaiInfo() : exception occured for " + id);
						throw new GenericException(ErrorMessages.NOT_FOUND, "Enter a valid number",
								HttpStatus.NOT_FOUND);
					}
				}
			} else {
				ValidationMessage validationMessage = new ValidationMessage("ERR", "id",
						"Size of the entered PDI or Claim Number is inappropriate");
				validationMessages.add(validationMessage);
				status = false;
			}
		} catch (DataAccessResourceFailureException e) {
			logger.error("RfaiServiceImpl.populateRfaiInfo() : exception occured while processing the claim for " + id
					+ " " + e);
			throw new GenericException(ErrorMessages.DATA_ACCESS_ERROR, e.getMessage(),
					HttpStatus.INTERNAL_SERVER_ERROR);
		} catch (DataAccessException e) {
			logger.error("RfaiServiceImpl.populateRfaiInfo() : exception occured while processing the claim for " + id
					+ " " + e);
			throw new GenericException(ErrorMessages.DATA_ACCESS_ERROR, e.getMessage(),
					HttpStatus.INTERNAL_SERVER_ERROR);
		} catch (Exception e) {
			logger.error("RfaiServiceImpl.populateRfaiInfo() : exception occured while processing the claim for " + id
					+ " " + e);
			throw new GenericException(ErrorMessages.NOT_FOUND, e.getMessage(), HttpStatus.NOT_FOUND);
		}

		if (!status) {
			throw new ValidationException("", validationMessages);
		}

		if (rfaiResponseResult != null) {
			return rfaiResponseResult;
		} else {
			logger.error("RfaiServiceImpl.populateRfaiInfo() : exception occured for " + id);
			throw new GenericException(ErrorMessages.NOT_FOUND, "Enter a valid number", HttpStatus.NOT_FOUND);
		}
	}

	private RfaiResponse addClaimLineItemInformation(Claim claimInfo, RfaiResponse rfaiResponseClaimResult)
			throws GenericException {
		RfaiResponse rfaiResponseResult = null;
		if (rfaiResponseClaimResult != null) {
			rfaiResponseClaimResult.setServiceFromDate(dateFormat.format(claimInfo.getBeginServiceDate()));
			rfaiResponseClaimResult.setServiceToDate(dateFormat.format(claimInfo.getEndServiceDate()));
			rfaiResponseResult = getClaimIdLineItemInformation(claimInfo.getClaimProcedures(), rfaiResponseClaimResult);
			if (rfaiResponseResult != null) {
				return rfaiResponseResult;
			} else {
				rfaiResponseResult = rfaiResponseClaimResult;
			}
		} else {
			logger.error(
					"RfaiServiceImpl.addClaimLineItemInformation() : exception occured while processing getClaimIdLineItemInformation() ");
			throw new GenericException(ErrorMessages.NOT_FOUND, "Enter a valid number", HttpStatus.NOT_FOUND);
		}

		return rfaiResponseResult;
	}

	private RfaiResponse addPdiLineItemInformation(EwvClaims ewvClaimsInfo, RfaiResponse rfaiResponseClaimResult)
			throws GenericException {
		RfaiResponse rfaiResponseResult = null;
		if (rfaiResponseClaimResult != null) {
			rfaiResponseClaimResult.setServiceFromDate(ewvClaimsInfo.getInvoiceStatementFromDate());
			rfaiResponseClaimResult.setServiceToDate(ewvClaimsInfo.getInvoiceStatementToDate());
			rfaiResponseResult = getPdiLineItemInformation(ewvClaimsInfo.getEwvServiceLineses(),
					rfaiResponseClaimResult);
			if (rfaiResponseResult != null) {
				return rfaiResponseResult;
			} else {
				rfaiResponseResult = rfaiResponseClaimResult;
			}
		} else {
			logger.error(
					"RfaiServiceImpl.addClaimLineItemInformation() : exception occured while processing getClaimIdLineItemInformation() ");
			throw new GenericException(ErrorMessages.NOT_FOUND, "Enter a valid number", HttpStatus.NOT_FOUND);
		}
		return rfaiResponseResult;
	}

	private boolean checkclaimType(String substring) {
		List<String> claimTypeCodes = Arrays.asList("03", "04", "05", "06", "07", "08", "09", "10", "50", "60", "70",
				"91", "92", "93", "94", "95", "96", "98", "99");
		if (claimTypeCodes.contains(substring)) {
			return true;
		}
		return false;
	}

	private RfaiResponse getPdiClaimInformation(EwvClaims ewvClaimsInfo,
			List<gov.va.med.domain.ereposModel.Claim> eReposClaimInfo, Long id) {
		RfaiResponse rfaiResponse = new RfaiResponse();
		if (ewvClaimsInfo != null) {
			rfaiResponse.setPatientIdentifier(ewvClaimsInfo.getPatientIdNumber());
			rfaiResponse.setPatientcontrolNumber(ewvClaimsInfo.getInvoicePatientAccountNum());
			/*
			 * if (ewvClaimsInfo.getServiceVendorName() != null) {
			 * rfaiResponse.setProviderInformation(ewvClaimsInfo.
			 * getServiceVendorName());
			 * rfaiResponse.setProviderTin(ewvClaimsInfo.
			 * getServiceVendorTaxIdNum());
			 * rfaiResponse.setProviderNpi(ewvClaimsInfo.getServiceVendorNpi());
			 * } else {
			 */
			rfaiResponse.setProviderInformation(ewvClaimsInfo.getBillingVendorName());
			rfaiResponse.setProviderTin(ewvClaimsInfo.getBillingVendorTaxIdNum());
			rfaiResponse.setProviderNpi(ewvClaimsInfo.getBillingVendorNpi());
			// }
			Date dt = new Date();
			LocalDateTime localDate = dt.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
			localDate = localDate.plusDays(5);
			Date currentDatePlusFiveDay = Date.from(localDate.atZone(ZoneId.systemDefault()).toInstant());
			rfaiResponse.setResponseDate(dateFormat.format(currentDatePlusFiveDay));
			rfaiResponse.setPayerClaimControlNumber(String.valueOf(id));

			if (ewvClaimsInfo.getPatientName() != null) {
				String[] splitted = ewvClaimsInfo.getPatientName().split("\\s*(=>|,|\\s)\\s*");
				if (splitted.length >= 2) {
					rfaiResponse.setPatientFirstName(splitted[1]);
					rfaiResponse.setPatientLastname(splitted[0]);
				} else {
					rfaiResponse.setPatientFirstName(splitted[1]);
				}
			}
		}
		if (!eReposClaimInfo.isEmpty()) {
			for (gov.va.med.domain.ereposModel.Claim eClaimInfo : eReposClaimInfo) {
				getInformationReceiver(eClaimInfo.getEntityNames(), rfaiResponse);
				getAdtlEntityInformation(eClaimInfo.getEntityAdtlIds(), rfaiResponse);
				rfaiResponse.setBillType(eClaimInfo.getClm05fclyTypeCd() + eClaimInfo.getClm05clmFrqCd());
			}
		}
		rfaiResponse.setPayerId(ewvPayerId);
		rfaiResponse.setPayerName(payerName);
		logger.info(" generateEwvClaimLevelData() : Ewv Claim information ");
		logger.debug("generateEwvClaimLevelData() : Ewv Claim information " + valueOf(rfaiResponse));
		return rfaiResponse;
	}

	private RfaiResponse getPdiLineItemInformation(Set<EwvServiceLines> ewvServiceLineses, RfaiResponse rfaiResponse) {
		List<RfaiLineItemResponse> rfaiLineItemResponseList = new ArrayList<>();
		for (EwvServiceLines esl : ewvServiceLineses) {
			BigDecimal chargeAmount = new BigDecimal(esl.getCharge());

			StringBuilder modifiers = new StringBuilder("");
			modifiers.append(StringUtils.isEmpty(esl.getModifier1()) ? "" : esl.getModifier1());
			modifiers.append(StringUtils.isEmpty(esl.getModifier2()) ? ""
					: (modifiers.length() > 0 ? "," : "") + esl.getModifier2());
			modifiers.append(StringUtils.isEmpty(esl.getModifier3()) ? ""
					: (modifiers.length() > 0 ? "," : "") + esl.getModifier3());
			modifiers.append(StringUtils.isEmpty(esl.getModifier4()) ? ""
					: (modifiers.length() > 0 ? "," : "") + esl.getModifier4());

			RfaiLineItemResponse rfaiLineItemResponse = new RfaiLineItemResponse(esl.getLineNumber(),
					esl.getBeginDateOfService(), esl.getEndDateOfService(), esl.getRevenueCode(),
					esl.getProcedureCode(), modifiers.toString(), chargeAmount);
			rfaiLineItemResponseList.add(rfaiLineItemResponse);
		}

		Collections.sort(rfaiLineItemResponseList, new Comparator<RfaiLineItemResponse>() {

			@Override
			public int compare(RfaiLineItemResponse o1, RfaiLineItemResponse o2) {
				return o1.getServiceLineId().compareTo(o2.getServiceLineId());
			}
		});
		rfaiResponse.setRfaiLineItemResponse(rfaiLineItemResponseList);
		logger.info(" getEwvLineItemInformation() : Ewv Line Item information ");
		logger.debug("getEwvLineItemInformation() : Ewv Line Item information " + valueOf(rfaiResponse));
		return rfaiResponse;
	}

	private RfaiResponse getClaimIdClaimInformation(Claim claimInfo,
			List<gov.va.med.domain.ereposModel.Claim> eReposClaimInfo, Long id) {
		RfaiResponse rfaiResponse = new RfaiResponse();
		if (claimInfo != null) {
			getProviderName(claimInfo.getProviderInfos(), rfaiResponse);
			getVeteranInfo(claimInfo.getPersonInfos(), rfaiResponse);
			rfaiResponse.setPatientcontrolNumber(claimInfo.getPatientControlNumber());
		}
		if (!eReposClaimInfo.isEmpty()) {
			for (gov.va.med.domain.ereposModel.Claim eClaimInfo : eReposClaimInfo) {
				getInformationReceiver(eClaimInfo.getEntityNames(), rfaiResponse);
				getAdtlEntityInformation(eClaimInfo.getEntityAdtlIds(), rfaiResponse);
				rfaiResponse.setBillType(eClaimInfo.getClm05fclyTypeCd() + eClaimInfo.getClm05clmFrqCd());
			}
		}
		Date dt = new Date();
		LocalDateTime localDate = dt.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
		localDate = localDate.plusDays(5);
		Date currentDatePlusFiveDay = Date.from(localDate.atZone(ZoneId.systemDefault()).toInstant());
		rfaiResponse.setResponseDate(dateFormat.format(currentDatePlusFiveDay));
		rfaiResponse.setPayerClaimControlNumber(String.valueOf(id));
		rfaiResponse.setPayerId(fppsPayerId);
		rfaiResponse.setPayerName(payerName);
		logger.info(" generateFppsClaimlevelData() : FPPS Claim information ");
		logger.debug("generateFppsClaimlevelData() : FPPS Claim information " + valueOf(rfaiResponse));
		return rfaiResponse;
	}

	private RfaiResponse getClaimIdLineItemInformation(Set<ClaimProcedure> claimProcedures, RfaiResponse rfaiResponse) {
		List<RfaiLineItemResponse> rfaiLineItemResponseList = new ArrayList<>();
		for (ClaimProcedure cp : claimProcedures) {

			StringBuilder modifiers = new StringBuilder("");
			modifiers.append(StringUtils.isEmpty(cp.getModifier1()) ? "" : cp.getModifier1());
			modifiers.append(StringUtils.isEmpty(cp.getModifier2()) ? ""
					: (modifiers.length() > 0 ? "," : "") + cp.getModifier2());
			modifiers.append(StringUtils.isEmpty(cp.getModifier3()) ? ""
					: (modifiers.length() > 0 ? "," : "") + cp.getModifier3());
			modifiers.append(StringUtils.isEmpty(cp.getModifier4()) ? ""
					: (modifiers.length() > 0 ? "," : "") + cp.getModifier4());

			RfaiLineItemResponse rfaiLineItemResponse = new RfaiLineItemResponse(cp.getClaimProcedureSeq(),
					dateFormat.format(cp.getServiceFromDate()), dateFormat.format(cp.getServiceToDate()),
					cp.getRevenueCode().getRevenueCd(), cp.getProcCode(), modifiers.toString(), cp.getBilledAmount());
			rfaiLineItemResponseList.add(rfaiLineItemResponse);
		}

		Collections.sort(rfaiLineItemResponseList, new Comparator<RfaiLineItemResponse>() {

			@Override
			public int compare(RfaiLineItemResponse o1, RfaiLineItemResponse o2) {
				return o1.getServiceLineId().compareTo(o2.getServiceLineId());
			}
		});

		rfaiResponse.setRfaiLineItemResponse(rfaiLineItemResponseList);
		logger.info(" getLineItemInformation() : FPPS Line information ");
		logger.debug("getLineItemInformation() : FPPS Line information " + valueOf(rfaiResponse));
		return rfaiResponse;
	}

	private void getAdtlEntityInformation(Set<EntityAdtlId> entityAdtlIds, RfaiResponse rfaiResponse) {
		for (EntityAdtlId eId : entityAdtlIds) {
			if ("D9".equals(eId.getRef01idQlfr())) {
				rfaiResponse.setClearingHouseId(eId.getRef02scndId());
			}
			if ("EA".equals(eId.getRef01idQlfr())) {
				rfaiResponse.setMedicalRecordNumber(eId.getRef02scndId());
			}
		}
	}

	private void getInformationReceiver(Set<EntityName> entityNames, RfaiResponse rfaiResponse) {
		for (EntityName e : entityNames) {
			if ("41".equals(e.getNm101entyIdCd())) {
				rfaiResponse.setInformationReceiver(e.getNm109idCd());
			}
		}
	}

	private void getProviderName(Set<ProviderInfo> providerInfos, RfaiResponse rfaiResponse) {
		for (ProviderInfo p : providerInfos) {
			if (p.getProviderType().getProviderTypeCd() != null) {
				/*
				 * if ("SERVICE FACILITY".equals(p.getProviderType().
				 * getProviderTypeCd()) ||
				 * "SERVICE LOCATION".equals(p.getProviderType().
				 * getProviderTypeCd())) {
				 * rfaiResponse.setProviderInformation(p.getLastName());
				 * rfaiResponse.setProviderTin(p.getProviderTin());
				 * rfaiResponse.setProviderNpi(p.getProviderNpi()); break; }
				 * else
				 */
				if ("BILLING PROVIDER".equals(p.getProviderType().getProviderTypeCd())
						|| "REMITADDR".equals(p.getProviderType().getProviderTypeCd())) {
					rfaiResponse.setProviderInformation(p.getLastName());
					rfaiResponse.setProviderTin(p.getProviderTin());
					rfaiResponse.setProviderNpi(p.getProviderNpi());
				}
			}
		}
	}

	private void getVeteranInfo(Set<PersonInfo> personInfos, RfaiResponse rfaiResponse) {
		for (PersonInfo pi : personInfos) {
			rfaiResponse.setPatientLastname(pi.getLastName());
			rfaiResponse.setPatientFirstName(pi.getFirstName());
			rfaiResponse.setPatientIdentifier(pi.getPersonId());

		}
	}

	public static String valueOf(Object obj) {
		return (obj == null) ? "null" : obj.toString();
	}
}
