/**
 * 
 */
package gov.va.med.ars.service.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import gov.va.med.ars.dao.CustomerDAO;
import gov.va.med.ars.model.Customer;
import gov.va.med.ars.service.ICustomerService;

/**
 * @author DNS   AI
 *
 */
@Service
public class CustomerServiceImpl implements ICustomerService {

	@Autowired
	CustomerDAO customerDAO;
	
	@Override
	public List<?> getList() {
		return customerDAO.list();
	}

	@Override
	public Customer getCustomer(Long id) {
		return customerDAO.get(id);
	}

	@Override
	public Customer updateCustomer(Long id, Customer customer) {
		return customerDAO.update(id, customer);
	}

	@Override
	public Customer createCustomer(Customer customer) {
		return customerDAO.create(customer);
	}

	@Override
	public Long deleteCustomer(Long id) {
		return customerDAO.delete(id);
	}

}
