package gov.va.med.ars.service.impl;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import gov.va.med.ars.dao.ars.ClaimContactRepository;
import gov.va.med.ars.dao.ars.ClaimSubmissionRepository;
import gov.va.med.ars.dao.ars.HccsCdRepository;
import gov.va.med.ars.dao.ars.LoincCdRepository;
import gov.va.med.ars.dao.ars.LoincModCdRepository;
import gov.va.med.ars.exceptions.GenericException;
import gov.va.med.ars.model.response.RfaiLineItemResponse;
import gov.va.med.ars.model.response.RfaiResponse;
import gov.va.med.ars.service.IAdditionalInfoRequestService;
import gov.va.med.domain.ars.ClaimContact;
import gov.va.med.domain.ars.ClaimSubmission;
import gov.va.med.domain.ars.ClaimSvcLines;
import gov.va.med.domain.ars.HccsCd;
import gov.va.med.domain.ars.LoincCd;
import gov.va.med.domain.ars.LoincModCd;


@Service
public class AdditionalInfoRequestServiceImpl implements IAdditionalInfoRequestService {
	private static final Logger logger = LogManager.getLogger(AdditionalInfoRequestServiceImpl.class);

	@Autowired
	private ClaimSubmissionRepository claimSubmissionRepo;
	
	@Autowired
	private ClaimContactRepository claimContactRepo;
	
	@Autowired
	private HccsCdRepository hccsCdRepo;
	
	@Autowired
	private LoincCdRepository loincCdRepo;
	
	@Autowired
	private LoincModCdRepository loincModRepo;

	@SuppressWarnings("deprecation")
	@Override
	public boolean submitAdditionalInfoRequest(RfaiResponse request) throws GenericException {
		logger.info("In AdditionalInfoRequestServiceImpl");
		boolean isCreated = false;
		Date dateCreatedAndModified = new Date(System.currentTimeMillis());
		
		Set<ClaimSvcLines> claimSvcLines = new HashSet<>();
		ClaimSubmission claimSubmission = new ClaimSubmission();
		
		if(request.getRfaiLineItemResponse() == null || request.getRfaiLineItemResponse().size() == 0) {
			claimSubmission.setDtp103svcfrmdt(new Date(request.getServiceFromDate()));
			claimSubmission.setDtp103svctodt(new Date(request.getServiceToDate()));
		}
		if (request.getRfaiLineItemResponse() != null && request.getRfaiLineItemResponse().size() != 0) {
			for (RfaiLineItemResponse rfiLine : request.getRfaiLineItemResponse()) {
				Date srvFrmdt = new Date(rfiLine.getServiceFrom());
				Date srvTodt = new Date(rfiLine.getServiceTo());
				ClaimSvcLines claimLine = new ClaimSvcLines();
				claimLine.setRef02svclnnmbr(rfiLine.getServiceLineId().toString());
				claimLine.setDtp03svcfrmdt(srvFrmdt);
				claimLine.setDtp03svctodt(srvTodt);
				claimLine.setSvc01revcd(rfiLine.getRevenueCode());
				claimLine.setSvc01proccd(rfiLine.getProcedurecode());
				claimLine.setSvc01mod(rfiLine.getModifiers());
				claimLine.setSvc02chrgamt(rfiLine.getChargeAmount());
				claimLine.setDatecreated(dateCreatedAndModified);
				claimLine.setDatemodified(dateCreatedAndModified);
				claimLine.setClaimSubmission(claimSubmission);
				claimSvcLines.add(claimLine);
			}
		}
				
		claimSubmission.setClaimSvcLineses(claimSvcLines);
		claimSubmission.setTrn02fppsClaimId(request.getClaimId());
		claimSubmission.setHl1nm103pyrNm(request.getPayerName());
		claimSubmission.setHl1nm109pyrId(request.getPayerId());
		claimSubmission.setHl2nm103infRcvr(request.getInformationReceiver());
		Date responseDate = new Date(request.getResponseDate());
		claimSubmission.setDtp203responseduedate(responseDate);
		claimSubmission.setHl3nm109prvnpi(request.getProviderNpi());
		claimSubmission.setHl2nm109svcprvtin(request.getProviderTin());
		claimSubmission.setHl4nm103ptlstnm(request.getPatientLastname());
		claimSubmission.setHl4nm104ptftnm(request.getPatientFirstName());
		claimSubmission.setHl4nm109ptid(request.getPatientIdentifier());
		claimSubmission.setRef102ptctrlnmbr(request.getPatientcontrolNumber());
		claimSubmission.setTrn02pyrclmctrlnmbr(request.getPayerClaimControlNumber());
		claimSubmission.setRef202billtype(request.getBillType());
		claimSubmission.setRef402clrnghsid(request.getClearingHouseId());
		claimSubmission.setRef302medrecnmbr(request.getMedicalRecordNumber());
		claimSubmission.setHl3nm103svcbillprvnm(request.getProviderInformation());

		LoincCd loincCd = new LoincCd();
		loincCd.setStcloincCd(request.getLoincCode());
		claimSubmission.setLoincCd(loincCd);

		LoincModCd loincModCd = loincModRepo.findOneByStcloincCdMod(request.getLoincCodeModifier());
		claimSubmission.setLoincModCd(loincModCd);
		

		HccsCd hccsCd = hccsCdRepo.findOneByStchccstatuscatCd(request.getClaimStatus());
		claimSubmission.setHccsCd(hccsCd);
		
		LoincCd loincCD = loincCdRepo.findOneByStcloincCd(request.getLoincCode());
		claimSubmission.setLoincCd(loincCD);

		ClaimContact claimContact = claimContactRepo.findOneByContactemail(request.getContactInformation());
		if (claimContact == null) {
			ClaimContact newContact = new ClaimContact();
			newContact.setContactemail(request.getContactInformation());
			newContact.setDatecreated(dateCreatedAndModified);
			newContact.setDatemodified(dateCreatedAndModified);
			claimContact = claimContactRepo.save(newContact);
		}
		claimSubmission.setClaimContact(claimContact); 
		
		claimSubmission.setDatecreated(dateCreatedAndModified);
		claimSubmission.setDatemodified(dateCreatedAndModified);
		
		try {
			ClaimSubmission clmSubmission = claimSubmissionRepo.save(claimSubmission);

			if (clmSubmission != null) {
				isCreated = true;
			} 
		} catch (Exception e) {
			logger.error("AdditionalInfoRequestServiceImpl.submitAdditionalInfoRequest() : exception occured while submitting additional info data " + "claimId = " + 
					request.getClaimId() + " " + e);
			throw new GenericException(e.getMessage());
		}
		return isCreated;
	}	
}