package gov.va.med.ars.model.response;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;

import gov.va.med.domain.ars.ClaimSubmission;
import gov.va.med.domain.ars.HccsCd;
import gov.va.med.domain.ars.LoincCd;
import gov.va.med.domain.ars.LoincModCd;

public class RfaiSubmissionResponse {

	@JsonInclude(JsonInclude.Include.NON_NULL)
	private Long claimId; 
	
	private String rfaiStatus; 
	private String rfaiSubmissionDate; 
	private String payerName; 
	private String payerId; 
	private String informationReceiver;  
	private String responseDate; 
	private String billingProvider; 
	private String providerNpi;  
	private String providerTin; 
	private String patientLastname; 
	private String patientFirstName; 
	private String patientIdentifier; 
	private String patientcontrolNumber;
	private String payerClaimControlNumber; 
	private String billType; 
	private String clearingHouseId; 
	private String medicalRecordNumber;  

	@JsonInclude(JsonInclude.Include.NON_NULL)
	private List<RfaiRelatedItemResponse> rfaiRelatedItemResponse;
	
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private List<String> statusCode;
	
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private List<String> loincCodes;
	
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private List<String> loincModCodes;
	
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String claimLevel;
	
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String attachments;
	
	/**
	 * 
	 */
	public RfaiSubmissionResponse() {
		super();
	}
	
	/**
	 * 
	 * @param claimId
	 * @param rfaiStatus
	 * @param rfaiSubmissionDate
	 * @param payerName
	 * @param payerId
	 * @param informationReceiver
	 * @param responseDate
	 * @param billingProvider
	 * @param providerNpi
	 * @param providerTin
	 * @param patientLastname
	 * @param patientFirstName
	 * @param patientIdentifier
	 * @param patientcontrolNumber
	 * @param payerClaimControlNumber
	 * @param billType
	 * @param clearingHouseId
	 * @param medicalRecordNumber
	 */
	public RfaiSubmissionResponse(Long claimId, String rfaiStatus, String rfaiSubmissionDate, String payerName,
			String payerId, String informationReceiver, String responseDate, String billingProvider, String providerNpi, String providerTin,
			String patientLastname, String patientFirstName, String patientIdentifier, String patientcontrolNumber,
			String payerClaimControlNumber, String billType, String clearingHouseId, String medicalRecordNumber) {
		super();
		this.claimId = claimId;
		this.rfaiStatus = rfaiStatus;
		this.rfaiSubmissionDate = rfaiSubmissionDate;
		this.payerName = payerName;
		this.payerId = payerId;
		this.informationReceiver = informationReceiver;
		this.responseDate = responseDate;
		this.billingProvider = billingProvider;
		this.providerNpi = providerNpi;
		this.providerTin = providerTin;
		this.patientLastname = patientLastname;
		this.patientFirstName = patientFirstName;
		this.patientIdentifier = patientIdentifier;
		this.patientcontrolNumber = patientcontrolNumber;
		this.payerClaimControlNumber = payerClaimControlNumber;
		this.billType = billType;
		this.clearingHouseId = clearingHouseId;
		this.medicalRecordNumber = medicalRecordNumber;
	}
	
	/**
	 * 
	 * @param claimId
	 * @param rfaiStatus
	 * @param rfaiSubmissionDate
	 * @param payerName
	 * @param payerId
	 * @param informationReceiver
	 * @param responseDate
	 * @param billingProvider
	 * @param providerNpi
	 * @param providerTin
	 * @param patientLastname
	 * @param patientFirstName
	 * @param patientIdentifier
	 * @param patientcontrolNumber
	 * @param payerClaimControlNumber
	 * @param billType
	 * @param clearingHouseId
	 * @param medicalRecordNumber
	 * @param rfaiRelatedItemResponse
	 * @param statusCode
	 * @param loincCodes
	 * @param loincModCodes
	 */
	public RfaiSubmissionResponse(Long claimId, String rfaiStatus, String rfaiSubmissionDate, String payerName,
			String payerId, String informationReceiver, String responseDate, String billingProvider, String providerNpi, String providerTin,
			String patientLastname, String patientFirstName, String patientIdentifier, String patientcontrolNumber,
			String payerClaimControlNumber, String billType, String clearingHouseId, String medicalRecordNumber,
			List<RfaiRelatedItemResponse> rfaiRelatedItemResponse, List<String> statusCode, List<String> loincCodes,
			List<String> loincModCodes, String claimLevel, String attachments) {
		super();
		this.claimId = claimId;
		this.rfaiStatus = rfaiStatus;
		this.rfaiSubmissionDate = rfaiSubmissionDate;
		this.payerName = payerName;
		this.payerId = payerId;
		this.informationReceiver = informationReceiver;
		this.responseDate = responseDate;
		this.billingProvider = billingProvider;
		this.providerNpi = providerNpi;
		this.providerTin = providerTin;
		this.patientLastname = patientLastname;
		this.patientFirstName = patientFirstName;
		this.patientIdentifier = patientIdentifier;
		this.patientcontrolNumber = patientcontrolNumber;
		this.payerClaimControlNumber = payerClaimControlNumber;
		this.billType = billType;
		this.clearingHouseId = clearingHouseId;
		this.medicalRecordNumber = medicalRecordNumber;
		this.rfaiRelatedItemResponse = rfaiRelatedItemResponse;
		this.statusCode = statusCode;
		this.loincCodes = loincCodes;
		this.loincModCodes = loincModCodes;
		this.claimLevel=claimLevel;
		this.attachments=attachments;
	}

	public Long getClaimId() {
		return claimId;
	}

	public void setClaimId(Long claimId) {
		this.claimId = claimId;
	}

	public String getRfaiStatus() {
		return rfaiStatus;
	}

	public void setRfaiStatus(String rfaiStatus) {
		this.rfaiStatus = rfaiStatus;
	}

	public String getRfaiSubmissionDate() {
		return rfaiSubmissionDate;
	}

	public void setRfaiSubmissionDate(String rfaiSubmissionDate) {
		this.rfaiSubmissionDate = rfaiSubmissionDate;
	}

	public String getPayerName() {
		return payerName;
	}

	public void setPayerName(String payerName) {
		this.payerName = payerName;
	}

	public String getPayerId() {
		return payerId;
	}

	public void setPayerId(String payerId) {
		this.payerId = payerId;
	}

	public String getInformationReceiver() {
		return informationReceiver;
	}

	public void setInformationReceiver(String informationReceiver) {
		this.informationReceiver = informationReceiver;
	}

	public String getResponseDate() {
		return responseDate;
	}

	public void setResponseDate(String responseDate) {
		this.responseDate = responseDate;
	}

	public String getBillingProvider() {
		return billingProvider;
	}

	public void setBillingProvider(String billingProvider) {
		this.billingProvider = billingProvider;
	}

	public String getProviderNpi() {
		return providerNpi;
	}

	public void setProviderNpi(String providerNpi) {
		this.providerNpi = providerNpi;
	}

	public String getProviderTin() {
		return providerTin;
	}

	public void setProviderTin(String providerTin) {
		this.providerTin = providerTin;
	}

	public String getPatientLastname() {
		return patientLastname;
	}

	public void setPatientLastname(String patientLastname) {
		this.patientLastname = patientLastname;
	}

	public String getPatientFirstName() {
		return patientFirstName;
	}

	public void setPatientFirstName(String patientFirstName) {
		this.patientFirstName = patientFirstName;
	}

	public String getPatientIdentifier() {
		return patientIdentifier;
	}

	public void setPatientIdentifier(String patientIdentifier) {
		this.patientIdentifier = patientIdentifier;
	}

	public String getPatientcontrolNumber() {
		return patientcontrolNumber;
	}

	public void setPatientcontrolNumber(String patientcontrolNumber) {
		this.patientcontrolNumber = patientcontrolNumber;
	}

	public String getPayerClaimControlNumber() {
		return payerClaimControlNumber;
	}

	public void setPayerClaimControlNumber(String payerClaimControlNumber) {
		this.payerClaimControlNumber = payerClaimControlNumber;
	}

	public String getBillType() {
		return billType;
	}

	public void setBillType(String billType) {
		this.billType = billType;
	}

	public String getClearingHouseId() {
		return clearingHouseId;
	}

	public void setClearingHouseId(String clearingHouseId) {
		this.clearingHouseId = clearingHouseId;
	}

	public String getMedicalRecordNumber() {
		return medicalRecordNumber;
	}

	public void setMedicalRecordNumber(String medicalRecordNumber) {
		this.medicalRecordNumber = medicalRecordNumber;
	}

	public List<RfaiRelatedItemResponse> getRfaiRelatedItemResponse() {
		return rfaiRelatedItemResponse;
	}

	public void setRfaiRelatedItemResponse(List<RfaiRelatedItemResponse> rfaiRelatedItemResponse) {
		this.rfaiRelatedItemResponse = rfaiRelatedItemResponse;
	}

	public List<String> getStatusCode() {
		return statusCode;
	}

	public void setStatusCode(List<String> statusCode) {
		this.statusCode = statusCode;
	}

	public List<String> getLoincCodes() {
		return loincCodes;
	}

	public void setLoincCodes(List<String> loincCodes) {
		this.loincCodes = loincCodes;
	}

	public List<String> getLoincModCodes() {
		return loincModCodes;
	}

	public void setLoincModCodes(List<String> loincModCodes) {
		this.loincModCodes = loincModCodes;
	}

	public String getClaimLevel() {
		return claimLevel;
	}

	public void setClaimLevel(String claimLevel) {
		this.claimLevel = claimLevel;
	}

	public String getAttachments() {
		return attachments;
	}

	public void setAttachments(String attachments) {
		this.attachments = attachments;
	}
}