package gov.va.med.ars.model.response;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

/**
 * @author DNS   AI
 *
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class RfaiResponse {

	@JsonInclude(JsonInclude.Include.NON_NULL)
	private Long claimId;

	private String payerName;
	private String payerId;
	private String informationReceiver;
	private String responseDate;

	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String contactInformation;

	private String providerInformation;
	private String providerNpi;
	private String providerTin;
	private String patientLastname;
	private String patientFirstName;
	private String patientIdentifier;
	private String patientcontrolNumber;
	private String payerClaimControlNumber;
	private String billType;
	private String clearingHouseId;
	private String medicalRecordNumber;

	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String serviceFromDate;
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String serviceToDate;

	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String claimStatus;
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String loincCode;
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String loincCodeModifier;

	@JsonInclude(JsonInclude.Include.NON_NULL)
	private List<RfaiLineItemResponse> rfaiLineItemResponse;

	/**
	 * 
	 */
	public RfaiResponse() {
		super();
	}

	/**
	 * @param claimId
	 * @param payerName
	 * @param payerId
	 * @param informationReceiver
	 * @param responseDate
	 * @param providerInformation
	 * @param providerNpi
	 * @param provicerTin
	 * @param patientLastname
	 * @param patientFirstName
	 * @param patientIdentifier
	 * @param patientcontrolNumber
	 * @param payerClaimControlNumber
	 * @param billType
	 * @param clearingHouseId
	 * @param medicalRecordNumber
	 * @param serviceFromDate
	 * @param servicetoDate
	 */
	public RfaiResponse(Long claimId, String payerName, String payerId, String informationReceiver, String responseDate,
			String providerInformation, String providerNpi, String provicerTin, String patientLastname,
			String patientFirstName, String patientIdentifier, String patientcontrolNumber,
			String payerClaimControlNumber, String billType, String clearingHouseId, String medicalRecordNumber,
			String serviceFromDate, String servicetoDate) {
		super();
		this.claimId = claimId;
		this.payerName = payerName;
		this.payerId = payerId;
		this.informationReceiver = informationReceiver;
		this.responseDate = responseDate;
		this.providerInformation = providerInformation;
		this.providerNpi = providerNpi;
		this.providerTin = provicerTin;
		this.patientLastname = patientLastname;
		this.patientFirstName = patientFirstName;
		this.patientIdentifier = patientIdentifier;
		this.patientcontrolNumber = patientcontrolNumber;
		this.payerClaimControlNumber = payerClaimControlNumber;
		this.billType = billType;
		this.clearingHouseId = clearingHouseId;
		this.medicalRecordNumber = medicalRecordNumber;
		this.serviceFromDate = serviceFromDate;
		this.serviceToDate = servicetoDate;
	}

	/**
	 * @param claimId
	 * @param payerName
	 * @param payerId
	 * @param informationReceiver
	 * @param responseDate
	 * @param providerInformation
	 * @param providerNpi
	 * @param provicerTin
	 * @param patientLastname
	 * @param patientFirstName
	 * @param patientIdentifier
	 * @param patientcontrolNumber
	 * @param payerClaimControlNumber
	 * @param billType
	 * @param clearingHouseId
	 * @param medicalRecordNumber
	 * @param serviceFromDate
	 * @param servicetoDate
	 * @param rfaiLineItemResponse
	 */
	public RfaiResponse(Long claimId, String payerName, String payerId, String informationReceiver, String responseDate,
			String providerInformation, String providerNpi, String provicerTin, String patientLastname,
			String patientFirstName, String patientIdentifier, String patientcontrolNumber,
			String payerClaimControlNumber, String billType, String clearingHouseId, String medicalRecordNumber,
			String serviceFromDate, String servicetoDate, List<RfaiLineItemResponse> rfaiLineItemResponse) {
		super();
		this.claimId = claimId;
		this.payerName = payerName;
		this.payerId = payerId;
		this.informationReceiver = informationReceiver;
		this.responseDate = responseDate;
		this.providerInformation = providerInformation;
		this.providerNpi = providerNpi;
		this.providerTin = provicerTin;
		this.patientLastname = patientLastname;
		this.patientFirstName = patientFirstName;
		this.patientIdentifier = patientIdentifier;
		this.patientcontrolNumber = patientcontrolNumber;
		this.payerClaimControlNumber = payerClaimControlNumber;
		this.billType = billType;
		this.clearingHouseId = clearingHouseId;
		this.medicalRecordNumber = medicalRecordNumber;
		this.serviceFromDate = serviceFromDate;
		this.serviceToDate = servicetoDate;
		this.rfaiLineItemResponse = rfaiLineItemResponse;
	}

	/**
	 * @param claimId
	 * @param payerName
	 * @param payerId
	 * @param informationReceiver
	 * @param responseDate
	 * @param contactInformation
	 * @param providerInformation
	 * @param providerNpi
	 * @param provicerTin
	 * @param patientLastname
	 * @param patientFirstName
	 * @param patientIdentifier
	 * @param patientcontrolNumber
	 * @param payerClaimControlNumber
	 * @param billType
	 * @param clearingHouseId
	 * @param medicalRecordNumber
	 * @param serviceFromDate
	 * @param servicetoDate
	 * @param claimStatus
	 * @param loincCode
	 * @param loincModifier
	 * @param rfaiLineItemResponse
	 */
	public RfaiResponse(Long claimId, String payerName, String payerId, String informationReceiver, String responseDate,
			String contactInformation, String providerInformation, String providerNpi, String provicerTin,
			String patientLastname, String patientFirstName, String patientIdentifier, String patientcontrolNumber,
			String payerClaimControlNumber, String billType, String clearingHouseId, String medicalRecordNumber,
			String serviceFromDate, String servicetoDate, String claimStatus, String loincCode, String loincCodeModifier,
			List<RfaiLineItemResponse> rfaiLineItemResponse) {
		super();
		this.claimId = claimId;
		this.payerName = payerName;
		this.payerId = payerId;
		this.informationReceiver = informationReceiver;
		this.responseDate = responseDate;
		this.contactInformation = contactInformation;
		this.providerInformation = providerInformation;
		this.providerNpi = providerNpi;
		this.providerTin = provicerTin;
		this.patientLastname = patientLastname;
		this.patientFirstName = patientFirstName;
		this.patientIdentifier = patientIdentifier;
		this.patientcontrolNumber = patientcontrolNumber;
		this.payerClaimControlNumber = payerClaimControlNumber;
		this.billType = billType;
		this.clearingHouseId = clearingHouseId;
		this.medicalRecordNumber = medicalRecordNumber;
		this.serviceFromDate = serviceFromDate;
		this.serviceToDate = servicetoDate;
		this.claimStatus = claimStatus;
		this.loincCode = loincCode;
		this.loincCodeModifier = loincCodeModifier;
		this.rfaiLineItemResponse = rfaiLineItemResponse;
	}

	/**
	 * 
	 * @return claimId
	 */
	public Long getClaimId() {
		return claimId;
	}

	/**
	 * 
	 * @param claimId
	 */
	public void setClaimId(Long claimId) {
		this.claimId = claimId;
	}

	/**
	 * 
	 * @return claimStatus
	 */
	public String getClaimStatus() {
		return claimStatus;
	}

	/**
	 * 
	 * @param claimStatus
	 */
	public void setClaimStatus(String claimStatus) {
		this.claimStatus = claimStatus;
	}

	/**
	 * 
	 * @return loincCode
	 */
	public String getLoincCode() {
		return loincCode;
	}

	/**
	 * 
	 * @param loincCode
	 */
	public void setLoincCode(String loincCode) {
		this.loincCode = loincCode;
	}

	/**
	 * 
	 * @return loincModifier
	 */
	public String getLoincCodeModifier() {
		return loincCodeModifier;
	}

	/**
	 * 
	 * @param loincModifier
	 */
	public void setLoincCodeModifier(String loincCodeModifier) {
		this.loincCodeModifier = loincCodeModifier;
	}

	/**
	 * @return the payerName
	 */
	public String getPayerName() {
		return payerName;
	}

	/**
	 * @param payerName
	 *            the payerName to set
	 */
	public void setPayerName(String payerName) {
		this.payerName = payerName;
	}

	/**
	 * @return the payerId
	 */
	public String getPayerId() {
		return payerId;
	}

	/**
	 * @param payerId
	 *            the payerId to set
	 */
	public void setPayerId(String payerId) {
		this.payerId = payerId;
	}

	/**
	 * @return the informationReceiver
	 */
	public String getInformationReceiver() {
		return informationReceiver;
	}

	/**
	 * @param informationReceiver
	 *            the informationReceiver to set
	 */
	public void setInformationReceiver(String informationReceiver) {
		this.informationReceiver = informationReceiver;
	}

	/**
	 * @return the responseDate
	 */
	public String getResponseDate() {
		return responseDate;
	}

	/**
	 * @param responseDate
	 *            the responseDate to set
	 */
	public void setResponseDate(String responseDate) {
		this.responseDate = responseDate;
	}

	/**
	 * @return the contactInformation
	 */
	public String getContactInformation() {
		return contactInformation;
	}

	/**
	 * @param contactInformation
	 *            the contactInformation to set
	 */
	public void setContactInformation(String contactInformation) {
		this.contactInformation = contactInformation;
	}

	/**
	 * @return the providerInformation
	 */
	public String getProviderInformation() {
		return providerInformation;
	}

	/**
	 * @param providerInformation
	 *            the providerInformation to set
	 */
	public void setProviderInformation(String providerInformation) {
		this.providerInformation = providerInformation;
	}

	/**
	 * @return the providerNpi
	 */
	public String getProviderNpi() {
		return providerNpi;
	}

	/**
	 * @param providerNpi
	 *            the providerNpi to set
	 */
	public void setProviderNpi(String providerNpi) {
		this.providerNpi = providerNpi;
	}

	/**
	 * @return the provicerTin
	 */
	public String getProviderTin() {
		return providerTin;
	}

	/**
	 * @param providerTin
	 *            the provicerTin to set
	 */
	public void setProviderTin(String providerTin) {
		this.providerTin = providerTin;
	}

	/**
	 * @return the patientLastname
	 */
	public String getPatientLastname() {
		return patientLastname;
	}

	/**
	 * @param patientLastname
	 *            the patientLastname to set
	 */
	public void setPatientLastname(String patientLastname) {
		this.patientLastname = patientLastname;
	}

	/**
	 * @return the patientFirstName
	 */
	public String getPatientFirstName() {
		return patientFirstName;
	}

	/**
	 * @param patientFirstName
	 *            the patientFirstName to set
	 */
	public void setPatientFirstName(String patientFirstName) {
		this.patientFirstName = patientFirstName;
	}

	/**
	 * @return the patientIdentifier
	 */
	public String getPatientIdentifier() {
		return patientIdentifier;
	}

	/**
	 * @param patientIdentifier
	 *            the patientIdentifier to set
	 */
	public void setPatientIdentifier(String patientIdentifier) {
		this.patientIdentifier = patientIdentifier;
	}

	/**
	 * @return the patientcontrolNumber
	 */
	public String getPatientcontrolNumber() {
		return patientcontrolNumber;
	}

	/**
	 * @param patientcontrolNumber
	 *            the patientcontrolNumber to set
	 */
	public void setPatientcontrolNumber(String patientcontrolNumber) {
		this.patientcontrolNumber = patientcontrolNumber;
	}

	/**
	 * @return the payerClaimControlNumber
	 */
	public String getPayerClaimControlNumber() {
		return payerClaimControlNumber;
	}

	/**
	 * @param payerClaimControlNumber
	 *            the payerClaimControlNumber to set
	 */
	public void setPayerClaimControlNumber(String payerClaimControlNumber) {
		this.payerClaimControlNumber = payerClaimControlNumber;
	}

	/**
	 * @return the billType
	 */
	public String getBillType() {
		return billType;
	}

	/**
	 * @param billType
	 *            the billType to set
	 */
	public void setBillType(String billType) {
		this.billType = billType;
	}

	/**
	 * @return the medicalRecordNumber
	 */
	public String getMedicalRecordNumber() {
		return medicalRecordNumber;
	}

	/**
	 * @param medicalRecordNumber
	 *            the medicalRecordNumber to set
	 */
	public void setMedicalRecordNumber(String medicalRecordNumber) {
		this.medicalRecordNumber = medicalRecordNumber;
	}

	/**
	 * @return the clearingHouseId
	 */
	public String getClearingHouseId() {
		return clearingHouseId;
	}

	/**
	 * @param clearingHouseId
	 *            the clearingHouseId to set
	 */
	public void setClearingHouseId(String clearingHouseId) {
		this.clearingHouseId = clearingHouseId;
	}

	/**
	 * @return the rfaiLineItemResponse
	 */
	public List<RfaiLineItemResponse> getRfaiLineItemResponse() {
		return rfaiLineItemResponse;
	}

	/**
	 * @param rfaiLineItemResponse
	 *            the rfaiLineItemResponse to set
	 */
	public void setRfaiLineItemResponse(List<RfaiLineItemResponse> rfaiLineItemResponse) {
		this.rfaiLineItemResponse = rfaiLineItemResponse;
	}

	/**
	 * @return the serviceFromDate
	 */
	public String getServiceFromDate() {
		return serviceFromDate;
	}

	/**
	 * @param serviceFromDate
	 *            the serviceFromDate to set
	 */
	public void setServiceFromDate(String serviceFromDate) {
		this.serviceFromDate = serviceFromDate;
	}

	/**
	 * @return the servicetoDate
	 */
	public String getServiceToDate() {
		return serviceToDate;
	}

	/**
	 * @param serviceToDate
	 *            the servicetoDate to set
	 */
	public void setServiceToDate(String serviceToDate) {
		this.serviceToDate = serviceToDate;
	}
}
