/**
 * 
 */
package gov.va.med.ars.model.request;

import org.springframework.stereotype.Component;

import com.fasterxml.jackson.annotation.JsonInclude;

/**
 * @author DNS   AI
 *
 */
@Component
public class RfaiLookupRequest {

	private Integer pageSize;
	private String sortColumn;
	private Boolean descending;
	private Integer pageNumber;
	
	private String number;

	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String providerName;
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String providerNpi;
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String providerTin;
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String patientLastName;
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String patientfirstName;
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String patientIdentifier;
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String patientControlNumber;
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String lineItemControlNumber;
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String serviceStartDate;
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String serviceEndDate;
	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String medicalRecordNumber;

	/**
	 * 
	 */
	public RfaiLookupRequest() {
		// TODO Auto-generated constructor stub
	}

	/**
	 * @param number
	 */
	public RfaiLookupRequest(String number) {
		super();
		this.number = number;
	}

	/**
	 * @param id
	 * @param providerName
	 * @param providerNpi
	 * @param providerTin
	 * @param patientLastName
	 * @param patientfirstName
	 * @param patientIdentifier
	 * @param patientControlNumber
	 * @param lineItemControlNumber
	 * @param serviceStartDate
	 * @param serviceEndDate
	 * @param medicalRecordNumber
	 */
	public RfaiLookupRequest(String number, String providerName, String providerNpi, String providerTin, String patientLastName,
			String patientfirstName, String patientIdentifier, String patientControlNumber, String lineItemControlNumber,
			String serviceStartDate, String serviceEndDate, String medicalRecordNumber) {
		super();
		this.number = number;
		this.providerName = providerName;
		this.providerNpi = providerNpi;
		this.providerTin = providerTin;
		this.patientLastName = patientLastName;
		this.patientfirstName = patientfirstName;
		this.patientIdentifier = patientIdentifier;
		this.patientControlNumber = patientControlNumber;
		this.lineItemControlNumber = lineItemControlNumber;
		this.serviceStartDate = serviceStartDate;
		this.serviceEndDate = serviceEndDate;
		this.medicalRecordNumber = medicalRecordNumber;
	}

	/**
	 * @return the number
	 */
	public String getNumber() {
		return number;
	}

	/**
	 * @param number the number to set
	 */
	public void setNumber(String number) {
		this.number = number;
	}

	/**
	 * @return the providerName
	 */
	public String getProviderName() {
		return providerName;
	}

	/**
	 * @param providerName the providerName to set
	 */
	public void setProviderName(String providerName) {
		this.providerName = providerName;
	}

	/**
	 * @return the providerNpi
	 */
	public String getProviderNpi() {
		return providerNpi;
	}

	/**
	 * @param providerNpi the providerNpi to set
	 */
	public void setProviderNpi(String providerNpi) {
		this.providerNpi = providerNpi;
	}

	/**
	 * @return the providerTin
	 */
	public String getProviderTin() {
		return providerTin;
	}

	/**
	 * @param providerTin the providerTin to set
	 */
	public void setProviderTin(String providerTin) {
		this.providerTin = providerTin;
	}

	/**
	 * @return the patientLastName
	 */
	public String getPatientLastName() {
		return patientLastName;
	}

	/**
	 * @param patientLastName the patientLastName to set
	 */
	public void setPatientLastName(String patientLastName) {
		this.patientLastName = patientLastName;
	}

	/**
	 * @return the patientfirstName
	 */
	public String getPatientfirstName() {
		return patientfirstName;
	}

	/**
	 * @param patientfirstName the patientfirstName to set
	 */
	public void setPatientfirstName(String patientfirstName) {
		this.patientfirstName = patientfirstName;
	}

	/**
	 * @return the patientIdentifier
	 */
	public String getPatientIdentifier() {
		return patientIdentifier;
	}

	/**
	 * @param patientIdentifier the patientIdentifier to set
	 */
	public void setPatientIdentifier(String patientIdentifier) {
		this.patientIdentifier = patientIdentifier;
	}

	/**
	 * @return the patientControlNumber
	 */
	public String getPatientControlNumber() {
		return patientControlNumber;
	}

	/**
	 * @param patientControlNumber the patientControlNumber to set
	 */
	public void setPatientControlNumber(String patientControlNumber) {
		this.patientControlNumber = patientControlNumber;
	}

	/**
	 * @return the lineItemControlNumber
	 */
	public String getLineItemControlNumber() {
		return lineItemControlNumber;
	}

	/**
	 * @param lineItemControlNumber the lineItemControlNumber to set
	 */
	public void setLineItemControlNumber(String lineItemControlNumber) {
		this.lineItemControlNumber = lineItemControlNumber;
	}

	/**
	 * @return the serviceStartDate
	 */
	public String getServiceStartDate() {
		return serviceStartDate;
	}

	/**
	 * @param serviceStartDate the serviceStartDate to set
	 */
	public void setServiceStartDate(String serviceStartDate) {
		this.serviceStartDate = serviceStartDate;
	}

	/**
	 * @return the serviceEndDate
	 */
	public String getServiceEndDate() {
		return serviceEndDate;
	}

	/**
	 * @param serviceEndDate the serviceEndDate to set
	 */
	public void setServiceEndDate(String serviceEndDate) {
		this.serviceEndDate = serviceEndDate;
	}

	/**
	 * @return the medicalRecordNumber
	 */
	public String getMedicalRecordNumber() {
		return medicalRecordNumber;
	}

	/**
	 * @param medicalRecordNumber the medicalRecordNumber to set
	 */
	public void setMedicalRecordNumber(String medicalRecordNumber) {
		this.medicalRecordNumber = medicalRecordNumber;
	}

	/**
	 * @return the pageSize
	 */
	public Integer getPageSize() {
		return pageSize;
	}

	/**
	 * @param pageSize the pageSize to set
	 */
	public void setPageSize(Integer pageSize) {
		this.pageSize = pageSize;
	}

	/**
	 * @return the sortColumn
	 */
	public String getSortColumn() {
		return sortColumn;
	}

	/**
	 * @param sortColumn the sortColumn to set
	 */
	public void setSortColumn(String sortColumn) {
		this.sortColumn = sortColumn;
	}

	/**
	 * @return the descending
	 */
	public Boolean getDescending() {
		return descending;
	}

	/**
	 * @param descending the descending to set
	 */
	public void setDescending(Boolean descending) {
		this.descending = descending;
	}

	/**
	 * @return the pageNumber
	 */
	public Integer getPageNumber() {
		return pageNumber;
	}

	/**
	 * @param pageNumber the pageNumber to set
	 */
	public void setPageNumber(Integer pageNumber) {
		this.pageNumber = pageNumber;
	}
}
