package gov.va.med.ars.exceptions;

import java.util.List;

import gov.va.med.ars.errorhandling.ValidationMessage;

/**
 * Indicate validation errors which are not handled via bean validation,
 * e.g. during file parsing
 *
 * @author Srini
 */
@SuppressWarnings("serial")
public class ValidationException extends BusinessException {

    private List<ValidationMessage> validationMessages;

    public ValidationException(String message) {
        super(message);
    }

    public ValidationException(String message, List<ValidationMessage> validationMessages) {
        super(message);
        this.validationMessages = validationMessages;
    }

    public List<ValidationMessage> getValidationMessages() {
        return validationMessages;
    }

}