package gov.va.med.ars.errorhandling;

import java.io.Serializable;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;

@SuppressWarnings("serial")
public class ValidationMessage implements Serializable {

	private String errorCode;

	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String entity;

	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String message;

	@JsonInclude(JsonInclude.Include.NON_NULL)
	private String messageTemplate;

	@JsonInclude(JsonInclude.Include.NON_NULL)
	private List<String> propertyList;

	public ValidationMessage() {
		super();
	}

	/*public ValidationMessage(String errorCode, String message) {
		super();
		this.errorCode = errorCode;
		this.message = message;
	}*/

	public ValidationMessage(String errorCode, String entity, String message) {
		super();
		this.errorCode = errorCode;
		this.entity = entity;
		this.message = message;
	}

	public ValidationMessage(String entity, String message, String messageTemplate, List<String> propertyList) {
		super();
		this.entity = entity;
		this.message = message;
		this.messageTemplate = messageTemplate;
		this.propertyList = propertyList;
	}

	public String getErrorCode() {
		return errorCode;
	}

	public void setErrorCode(String errorCode) {
		this.errorCode = errorCode;
	}

	public String getEntity() {
		return entity;
	}

	public void setEntity(String entity) {
		this.entity = entity;
	}

	public String getMessage() {
		return message;
	}

	public void setMessage(String message) {
		this.message = message;
	}

	public String getMessageTemplate() {
		return messageTemplate;
	}

	public void setMessageTemplate(String messageTemplate) {
		this.messageTemplate = messageTemplate;
	}

	public List<String> getPropertyList() {
		return propertyList;
	}

	public void setPropertyList(List<String> propertyList) {
		this.propertyList = propertyList;
	}

	@Override
	public String toString() {
		StringBuilder builder = new StringBuilder();
		builder.append("ValidationMessage [entity=");
		builder.append(entity);
		builder.append(", message=");
		builder.append(message);
		builder.append(", messageTemplate=");
		builder.append(messageTemplate);
		builder.append(", propertyList=");
		builder.append(propertyList);
		builder.append("]");
		return builder.toString();
	}
}
