/**
 * 
 */
package gov.va.med.ars.controller;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import gov.va.med.ars.exceptions.GenericException;
import gov.va.med.ars.model.request.RfaiLookupRequest;
import gov.va.med.ars.model.response.GenericResponse;
import gov.va.med.ars.service.IRfaiLookupService;

/**
 * @author DNS   DNS
 *
 */
@RestController
@RequestMapping("api/v1/searchRfai")
public class RfaiLookupController {

	private static final Logger logger = LogManager.getLogger(RfaiLookupController.class);
	
	@Autowired
	IRfaiLookupService lookupService;
	/**
	 * @throws GenericException 
	 * 
	 */
	@PostMapping(value = "/search")
	public ResponseEntity<?> getRfaiLookupController(@RequestBody RfaiLookupRequest rfaiLookupRequest, @RequestParam(value = "advSearch", required = false) boolean advSearch) throws GenericException {
		//lookupService.getRfaiSearchResults(rfaiLookupRequest);
		try {
			if(!advSearch) {
				GenericResponse searchResponse = lookupService.getRfaiSimpleSearchResults(rfaiLookupRequest);
				return new ResponseEntity<>(searchResponse, HttpStatus.OK);
			} else {
				GenericResponse searchResponse = lookupService.getRfaiAdvResults(rfaiLookupRequest);
				return new ResponseEntity<>(searchResponse, HttpStatus.OK);
			}
		} catch (Exception e) {
			logger.error(
					"RfaiLookupController:getRfaiLookupController() exception occured " + e.getMessage());
			throw e;
		}
	}

}
