/**
 * 
 */
package gov.va.med.ars.controller;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import gov.va.med.ars.exceptions.EntityNotFoundException;
import gov.va.med.ars.exceptions.GenericException;
import gov.va.med.ars.exceptions.ValidationException;
import gov.va.med.ars.model.response.RfaiResponse;
import gov.va.med.ars.service.IRfaiService;
import gov.va.med.ars.validators.ClaimNumberValidator;

/**
 * @author DNS   DNS
 *
 */
@RestController
@RequestMapping("api/v1/populateClaim")
public class RfaiController {

	private static final Logger logger = LogManager.getLogger(RfaiController.class);

	@Autowired
	IRfaiService rfaiService;

	@GetMapping("/{id}")
	public ResponseEntity<?> getClaim(@PathVariable("id") String id)
			throws ValidationException, GenericException, EntityNotFoundException {
		Long claimNumber = null;
		Boolean isValid;
		try {
			ClaimNumberValidator claimDetailsValidator = new ClaimNumberValidator();
			isValid = claimDetailsValidator.returnClaimNumber(id);
			if (isValid == true) {
				claimNumber = Long.valueOf(id);
			}

			if (claimNumber != null) {
				logger.info("RfaiController:getClaim() received the request for claim Number :" + claimNumber);

				logger.debug("RfaiController:getClaim() invoking the rfaiService.populateRfaiInfo() for claim index"
						+ claimNumber);
				RfaiResponse rfaiResponse = rfaiService.populateRfaiInfo(claimNumber);
				if (rfaiResponse == null) {
					return new ResponseEntity<>("No Claim found for ID " + id, HttpStatus.NOT_FOUND);
				}
				return new ResponseEntity<>(rfaiResponse, HttpStatus.OK);
			} else {
				return new ResponseEntity<>("No Claim found for ID " + id, HttpStatus.NOT_FOUND);
			}
		} catch (GenericException e) {
			logger.error(
					"RfaiController:getClaim() exception occured for claim index : " + id + " - " + e.getMessage());
			throw e;
		}
	}
}
