package gov.va.med.ars.controller;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import gov.va.med.ars.model.Customer;
import gov.va.med.ars.service.ICustomerService;
/**
 * 
 * @author DNS   DNS
 *
 */
@RestController
public class CustomerRestController {
	
	@Autowired
	private ICustomerService customerService;

	/*
	@GetMapping("/api/v1/customers")
	public List<?> getCustomers() {
		//return customerDAO.list();
		return customerService.getList();
	}*/

	@GetMapping("/api/v1/customers/{id}")
	public ResponseEntity<?> getCustomer(@PathVariable("id") Long id) {

		Customer customer = customerService.getCustomer(id);
		if (customer == null) {
			return new ResponseEntity<>("No Customer found for ID " + id, HttpStatus.NOT_FOUND);
		}

		return new ResponseEntity<>(customer, HttpStatus.OK);
	}

	@PostMapping(value = "/api/v1/customers")
	public ResponseEntity<?> createCustomer(@RequestBody Customer customer) {

		Customer createCustomer = customerService.createCustomer(customer);
		if(createCustomer != null) {
			return new ResponseEntity<>(customer, HttpStatus.OK);
		} else {
			return new ResponseEntity<>("Error in creating", HttpStatus.BAD_REQUEST);
		}
		
	}

	@DeleteMapping("/api/v1/customers/{id}")
	public ResponseEntity<?> deleteCustomer(@PathVariable Long id) {

		if (null == customerService.deleteCustomer(id)) {
			return new ResponseEntity<>("No Customer found for ID " + id, HttpStatus.NOT_FOUND);
		}

		return new ResponseEntity<>(id, HttpStatus.OK);

	}

	@PutMapping("/api/v1/customers/{id}")
	public ResponseEntity<?> updateCustomer(@PathVariable Long id, @RequestBody Customer customer) {

		customer = customerService.updateCustomer(id, customer);

		if (null == customer) {
			return new ResponseEntity<>("No Customer found for ID " + id, HttpStatus.NOT_FOUND);
		}

		return new ResponseEntity<>(customer, HttpStatus.OK);
	}

}