/**
 * 
 */
package gov.va.med.ars.configuration.hibernate;

import java.util.HashMap;

import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.jdbc.datasource.DriverManagerDataSource;
import org.springframework.orm.hibernate5.HibernateExceptionTranslator;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.orm.jpa.LocalContainerEntityManagerFactoryBean;
import org.springframework.orm.jpa.vendor.HibernateJpaVendorAdapter;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.EnableTransactionManagement;

/**
 * @author DNS   DNS
 *
 */

@Configuration
@EnableTransactionManagement
@EnableJpaRepositories(basePackages = "gov.va.med", entityManagerFactoryRef = "arsEntityManager", transactionManagerRef = "arsTransactionManager")
public class ArsPersistenceConfig {

	@Autowired
	private Environment env;

	@Primary
	@Bean(name = "arsEntityManager")
	public LocalContainerEntityManagerFactoryBean arsEntityManager() {
		final LocalContainerEntityManagerFactoryBean em = new LocalContainerEntityManagerFactoryBean();
		em.setDataSource(arsDataSource());
		em.setPackagesToScan(new String[] { "gov.va.med.domain" });

		final HibernateJpaVendorAdapter vendorAdapter = new HibernateJpaVendorAdapter();
		em.setJpaVendorAdapter(vendorAdapter);
		final HashMap<String, Object> properties = new HashMap<String, Object>();
		properties.put("hibernate.hbm2ddl.auto", env.getProperty("hibernate.hbm2ddl.auto"));
		properties.put("hibernate.dialect", env.getProperty("hibernate.dialect"));
		em.setJpaPropertyMap(properties);

		return em;
	}

	@Primary
	@Bean(name = "arsDataSource")
	public DataSource arsDataSource() {
		final DriverManagerDataSource dataSource = new DriverManagerDataSource();
		dataSource.setDriverClassName(env.getProperty("jdbc.ars.driverClassName"));
		dataSource.setUrl(env.getProperty("jdbc.ars.url"));
		dataSource.setUsername(env.getProperty("jdbc.ars.username"));
		dataSource.setPassword(env.getProperty("jdbc.ars.password"));

		return dataSource;
	}

	@Primary
	@Bean
	public HibernateExceptionTranslator hibernateExceptionTranslator() {
		return new HibernateExceptionTranslator();
	}

	@Primary
	@Bean(name = "arsTransactionManager")
	public PlatformTransactionManager arsTransactionManager() {
		EntityManagerFactory factory = arsEntityManager().getObject();
		
		return new JpaTransactionManager(factory);
	}

}
