package gov.va.med.domain.fppsowner;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

/**
 * New class to hold data from FPPS_OWNER.ADTL_CENTRAL_FEE table
 * Records written during Reconciliation process
 * Data from new Central Fee file input process
 * 12/13/2015
 * 

 * 
 * 
 * @author DNS   BLACKW
 */

@SuppressWarnings("serial")
@Entity(name = "foAdtlCentralFee")
@Table(name = "ADTL_CENTRAL_FEE")
public class AdtlCentralFee  implements java.io.Serializable {
	private int adtlCentralFeeId;
	private String feeClaimPaymentId;
	private long claimIndex;
	private String authorizationNumber;
	private String amountQualifierCode;
	private String lineItemSequence;

	private BigDecimal claimLevelAllowedAmount;
	private String loopId;
	private String txType;
	private String ref01;
	private String createdBy;
	private Date dateCreated;
	
	public AdtlCentralFee() {}
	
	public AdtlCentralFee(int adtlCentralFeeId, String feeClaimPaymentId, long claimIndex, String lineItemSequence,
			String authorizationNumber, String amountQualifierCode, BigDecimal claimLevelAllowedAmount, String loopId,
			String txType, String ref01, String createdBy, Date dateCreated) {
		
		this.adtlCentralFeeId = adtlCentralFeeId;
		this.feeClaimPaymentId = feeClaimPaymentId;
		this.claimIndex = claimIndex; 
		this.lineItemSequence = lineItemSequence;
		this.authorizationNumber = authorizationNumber;
		this.claimLevelAllowedAmount = claimLevelAllowedAmount;
		this.amountQualifierCode = amountQualifierCode;
		this.loopId = loopId;
		this.txType = txType;
		this.ref01 = ref01;
		this.createdBy = createdBy;
		this.dateCreated = dateCreated;
	}	// end constr()
	
	
	@Id
	@GeneratedValue(strategy = GenerationType.AUTO, generator = "fo_seq")
	@SequenceGenerator(name = "fo_seq", sequenceName = "FPPS_OWNER.MIG")
	@Column(name = "ADTL_CENTRAL_FEE_ID", unique = true, nullable = false, length = 12)
	public int getAdtlCentralFeeId() {
		return adtlCentralFeeId;
	}
	public void setAdtlCentralFeeId(int adtlCentralFeeId) {
		this.adtlCentralFeeId = adtlCentralFeeId;
	}
	
	@Column(name = "FEE_CLAIM_PAYMENT_ID", unique = true, nullable = false, length = 36)
	public String getFeeClaimPaymentId() {
		return feeClaimPaymentId;
	}
	public void setFeeClaimPaymentId(String feeClaimPaymentId) {
		this.feeClaimPaymentId = feeClaimPaymentId;
	}
	
	@Column(name = "LINE_ITEM_SEQUENCE", nullable = true, length = 2000)
	public String getLineItemSequence() {
		return lineItemSequence;
	}
	public void setLineItemSequence(String lineItemSequence) {
		this.lineItemSequence = lineItemSequence;
	}
	
	
	@Column(name = "CLAIM_INDEX", nullable = false, precision = 15, scale = 0)
	public long getClaimIndex() {
		return claimIndex;
	}
	public void setClaimIndex(long claimIndex) {
		this.claimIndex = claimIndex;
	}
	
    @Column(name = "CREATED_BY", nullable = false, length = 30)
	public String getCreatedBy() {
		return createdBy;
	}
	public void setCreatedBy(String createdBy) {
		this.createdBy = createdBy;
	}
	

	 @Override
	public String toString() {
		return "AdtlCentralFee [adtlCentralFeeId=" + adtlCentralFeeId
				+ ", feeClaimPaymentId=" + feeClaimPaymentId + ", claimIndex="
				+ claimIndex + ", lineItemSequence=" + lineItemSequence
				+ ", authorizationNumber=" + authorizationNumber
				+ ", amountQualifierCode=" + amountQualifierCode
				+ ", claimLevelAllowedAmount=" + claimLevelAllowedAmount
				+ ", loopId=" + loopId + ", txType=" + txType + ", ref01="
				+ ref01 + ", createdBy=" + createdBy + ", dateCreated="
				+ dateCreated + "]";
	}

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "DATE_CREATED", nullable = false, length = 7)
	public Date getDateCreated() {
		return dateCreated;
	}
	public void setDateCreated(Date dateCreated) {
		this.dateCreated = dateCreated;
	}

	
	@Column(name = "AUTHORIZATION_NUMBER", nullable = true, length = 50)
	public String getAuthorizationNumber() {
		return authorizationNumber;
	}
	public void setAuthorizationNumber(String authorizationNumber) {
		this.authorizationNumber = authorizationNumber;
	}
	
	@Column(name = "AMOUNT_QUALIFIER_CODE", nullable = true, length = 2)
	public String getAmountQualifierCode() {
		return amountQualifierCode;
	}

	public void setAmountQualifierCode(String amountQualifierCode) {
		this.amountQualifierCode = amountQualifierCode;
	}
	
	@Column(name = "CLAIM_LEVEL_ALLOWED_AMOUNT", precision = 10)
	public BigDecimal getClaimLevelAllowedAmount() {
		return claimLevelAllowedAmount;
	}
	public void setClaimLevelAllowedAmount(BigDecimal claimLevelAllowedAmount) {
		this.claimLevelAllowedAmount = claimLevelAllowedAmount;
	}
	
	@Column(name = "LOOP_ID", nullable = true, length = 12)
	public String getLoopId() {
		return loopId;
	}
	public void setLoopId(String loopId) {
		this.loopId = loopId;
	}
	
	@Column(name = "TX_TYPE", nullable = true, length = 10)
	public String getTxType() {
		return txType;
	}
	public void setTxType(String txType) {
		this.txType = txType;
	}

	@Column(name = "REF01", nullable = true, length = 2)
	public String getRef01() {
		return ref01;
	}

	public void setRef01(String ref01) {
		this.ref01 = ref01;
	}
	

}	// end class
