/*
 * $Id: ClaimReconciliation.java,v 1.18 2009/09/25 14:29:36 vhahacmagdua Exp $
 */
package gov.va.med.domain.fee;


// Generated Sep 25, 2009 7:47:29 AM by Hibernate Tools 3.2.5.Beta
import java.math.BigDecimal;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;


/**
 * ClaimReconciliation generated by hbm2java
 */
@SuppressWarnings("serial")
@Entity(name = "fClaimReconciliation")
@Table(name = "CLAIM_RECONCILIATION")
public class ClaimReconciliation implements java.io.Serializable {
    private long claimRecId;
    private Claim claim;
    private CalcMethod calcMethod;
    private String drgCd;
    private Byte coverageStatusCd;
    private BigDecimal inptAdjAllowableAmt;
    private BigDecimal claimCalcAllowableAmt;
    private String inptAdjAllowableUser;
    private Date inptAdjAllowableDate;
    private String inptIlogRule;
    private String inptIlogReason;
    private BigDecimal inptDrgBaseAmtCalc;
    private BigDecimal inptTransferOutlierAmt;
    private BigDecimal inptCostOutlierAmt;
    private Character medicareDeductClmFlag;
    private BigDecimal inptStayOutlierAmt;
    private BigDecimal rtcPerDiemRateUsed;
    private BigDecimal dmeDelivChgAllowAmt;
    private Long rejectedDupClaimIndex;
    private BigDecimal paidAmount;
    private BigDecimal disbursedAmount;
    private BigDecimal interestAmount;
    private Date periodStartDate;
    private Date periodEndDate;
    private Integer coveredDays;
    private BigDecimal progAllowableAmt;
    private BigDecimal beneCostShare;
    private Character sent835Flag;
    private Date sent835Date;
    private String drgCodeDesc;
    private String createdBy;
    private Date dateCreated;
    private String modifiedBy;
    private Date dateModified;
    private Set<ClaimProcRecon> claimProcRecons = new HashSet<ClaimProcRecon>(0);

    public ClaimReconciliation() {
    }

    public ClaimReconciliation(long claimRecId, Claim claim,
        CalcMethod calcMethod, String createdBy, Date dateCreated) {
        this.claimRecId = claimRecId;
        this.claim = claim;
        this.calcMethod = calcMethod;
        this.createdBy = createdBy;
        this.dateCreated = dateCreated;
    }

    public ClaimReconciliation(long claimRecId, Claim claim,
        CalcMethod calcMethod, String drgCd, Byte coverageStatusCd,
        BigDecimal inptAdjAllowableAmt, BigDecimal claimCalcAllowableAmt,
        String inptAdjAllowableUser, Date inptAdjAllowableDate,
        String inptIlogRule, String inptIlogReason,
        BigDecimal inptDrgBaseAmtCalc, BigDecimal inptTransferOutlierAmt,
        BigDecimal inptCostOutlierAmt, Character medicareDeductClmFlag,
        BigDecimal inptStayOutlierAmt, BigDecimal rtcPerDiemRateUsed,
        BigDecimal dmeDelivChgAllowAmt, Long rejectedDupClaimIndex,
        BigDecimal paidAmount, BigDecimal disbursedAmount,
        BigDecimal interestAmount, Date periodStartDate, Date periodEndDate,
        Integer coveredDays, BigDecimal progAllowableAmt,
        BigDecimal beneCostShare, Character sent835Flag, Date sent835Date,
        String drgCodeDesc, String createdBy, Date dateCreated,
        String modifiedBy, Date dateModified,
        Set<ClaimProcRecon> claimProcRecons) {
        this.claimRecId = claimRecId;
        this.claim = claim;
        this.calcMethod = calcMethod;
        this.drgCd = drgCd;
        this.coverageStatusCd = coverageStatusCd;
        this.inptAdjAllowableAmt = inptAdjAllowableAmt;
        this.claimCalcAllowableAmt = claimCalcAllowableAmt;
        this.inptAdjAllowableUser = inptAdjAllowableUser;
        this.inptAdjAllowableDate = inptAdjAllowableDate;
        this.inptIlogRule = inptIlogRule;
        this.inptIlogReason = inptIlogReason;
        this.inptDrgBaseAmtCalc = inptDrgBaseAmtCalc;
        this.inptTransferOutlierAmt = inptTransferOutlierAmt;
        this.inptCostOutlierAmt = inptCostOutlierAmt;
        this.medicareDeductClmFlag = medicareDeductClmFlag;
        this.inptStayOutlierAmt = inptStayOutlierAmt;
        this.rtcPerDiemRateUsed = rtcPerDiemRateUsed;
        this.dmeDelivChgAllowAmt = dmeDelivChgAllowAmt;
        this.rejectedDupClaimIndex = rejectedDupClaimIndex;
        this.paidAmount = paidAmount;
        this.disbursedAmount = disbursedAmount;
        this.interestAmount = interestAmount;
        this.periodStartDate = periodStartDate;
        this.periodEndDate = periodEndDate;
        this.coveredDays = coveredDays;
        this.progAllowableAmt = progAllowableAmt;
        this.beneCostShare = beneCostShare;
        this.sent835Flag = sent835Flag;
        this.sent835Date = sent835Date;
        this.drgCodeDesc = drgCodeDesc;
        this.createdBy = createdBy;
        this.dateCreated = dateCreated;
        this.modifiedBy = modifiedBy;
        this.dateModified = dateModified;
        this.claimProcRecons = claimProcRecons;
    }

    @Id
    @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "f_seq")
    @SequenceGenerator(name = "f_seq", sequenceName = "FPPS_OWNER.MIG")
    @Column(name = "CLAIM_REC_ID", unique = true, nullable = false, precision = 15, scale = 0)
    public long getClaimRecId() {
        return this.claimRecId;
    }

    public void setClaimRecId(long claimRecId) {
        this.claimRecId = claimRecId;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "CLAIM_INDEX", nullable = false)
    public Claim getClaim() {
        return this.claim;
    }

    public void setClaim(Claim claim) {
        this.claim = claim;
    }

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "CALC_METHOD_CD", nullable = false)
    public CalcMethod getCalcMethod() {
        return this.calcMethod;
    }

    public void setCalcMethod(CalcMethod calcMethod) {
        this.calcMethod = calcMethod;
    }

    @Column(name = "DRG_CD", length = 12)
    public String getDrgCd() {
        return this.drgCd;
    }

    public void setDrgCd(String drgCd) {
        this.drgCd = drgCd;
    }

    @Column(name = "COVERAGE_STATUS_CD", precision = 2, scale = 0)
    public Byte getCoverageStatusCd() {
        return this.coverageStatusCd;
    }

    public void setCoverageStatusCd(Byte coverageStatusCd) {
        this.coverageStatusCd = coverageStatusCd;
    }

    @Column(name = "INPT_ADJ_ALLOWABLE_AMT", precision = 10)
    public BigDecimal getInptAdjAllowableAmt() {
        return this.inptAdjAllowableAmt;
    }

    public void setInptAdjAllowableAmt(BigDecimal inptAdjAllowableAmt) {
        this.inptAdjAllowableAmt = inptAdjAllowableAmt;
    }

    @Column(name = "CLAIM_CALC_ALLOWABLE_AMT", precision = 10)
    public BigDecimal getClaimCalcAllowableAmt() {
        return this.claimCalcAllowableAmt;
    }

    public void setClaimCalcAllowableAmt(BigDecimal claimCalcAllowableAmt) {
        this.claimCalcAllowableAmt = claimCalcAllowableAmt;
    }

    @Column(name = "INPT_ADJ_ALLOWABLE_USER", length = 30)
    public String getInptAdjAllowableUser() {
        return this.inptAdjAllowableUser;
    }

    public void setInptAdjAllowableUser(String inptAdjAllowableUser) {
        this.inptAdjAllowableUser = inptAdjAllowableUser;
    }

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "INPT_ADJ_ALLOWABLE_DATE", length = 7)
    public Date getInptAdjAllowableDate() {
        return this.inptAdjAllowableDate;
    }

    public void setInptAdjAllowableDate(Date inptAdjAllowableDate) {
        this.inptAdjAllowableDate = inptAdjAllowableDate;
    }

    @Column(name = "INPT_ILOG_RULE", length = 100)
    public String getInptIlogRule() {
        return this.inptIlogRule;
    }

    public void setInptIlogRule(String inptIlogRule) {
        this.inptIlogRule = inptIlogRule;
    }

    @Column(name = "INPT_ILOG_REASON", length = 100)
    public String getInptIlogReason() {
        return this.inptIlogReason;
    }

    public void setInptIlogReason(String inptIlogReason) {
        this.inptIlogReason = inptIlogReason;
    }

    @Column(name = "INPT_DRG_BASE_AMT_CALC", precision = 10)
    public BigDecimal getInptDrgBaseAmtCalc() {
        return this.inptDrgBaseAmtCalc;
    }

    public void setInptDrgBaseAmtCalc(BigDecimal inptDrgBaseAmtCalc) {
        this.inptDrgBaseAmtCalc = inptDrgBaseAmtCalc;
    }

    @Column(name = "INPT_TRANSFER_OUTLIER_AMT", precision = 10)
    public BigDecimal getInptTransferOutlierAmt() {
        return this.inptTransferOutlierAmt;
    }

    public void setInptTransferOutlierAmt(BigDecimal inptTransferOutlierAmt) {
        this.inptTransferOutlierAmt = inptTransferOutlierAmt;
    }

    @Column(name = "INPT_COST_OUTLIER_AMT", precision = 10)
    public BigDecimal getInptCostOutlierAmt() {
        return this.inptCostOutlierAmt;
    }

    public void setInptCostOutlierAmt(BigDecimal inptCostOutlierAmt) {
        this.inptCostOutlierAmt = inptCostOutlierAmt;
    }

    @Column(name = "MEDICARE_DEDUCT_CLM_FLAG", length = 1)
    public Character getMedicareDeductClmFlag() {
        return this.medicareDeductClmFlag;
    }

    public void setMedicareDeductClmFlag(Character medicareDeductClmFlag) {
        this.medicareDeductClmFlag = medicareDeductClmFlag;
    }

    @Column(name = "INPT_STAY_OUTLIER_AMT", precision = 10)
    public BigDecimal getInptStayOutlierAmt() {
        return this.inptStayOutlierAmt;
    }

    public void setInptStayOutlierAmt(BigDecimal inptStayOutlierAmt) {
        this.inptStayOutlierAmt = inptStayOutlierAmt;
    }

    @Column(name = "RTC_PER_DIEM_RATE_USED", precision = 10)
    public BigDecimal getRtcPerDiemRateUsed() {
        return this.rtcPerDiemRateUsed;
    }

    public void setRtcPerDiemRateUsed(BigDecimal rtcPerDiemRateUsed) {
        this.rtcPerDiemRateUsed = rtcPerDiemRateUsed;
    }

    @Column(name = "DME_DELIV_CHG_ALLOW_AMT", precision = 10)
    public BigDecimal getDmeDelivChgAllowAmt() {
        return this.dmeDelivChgAllowAmt;
    }

    public void setDmeDelivChgAllowAmt(BigDecimal dmeDelivChgAllowAmt) {
        this.dmeDelivChgAllowAmt = dmeDelivChgAllowAmt;
    }

    @Column(name = "REJECTED_DUP_CLAIM_INDEX", precision = 15, scale = 0)
    public Long getRejectedDupClaimIndex() {
        return this.rejectedDupClaimIndex;
    }

    public void setRejectedDupClaimIndex(Long rejectedDupClaimIndex) {
        this.rejectedDupClaimIndex = rejectedDupClaimIndex;
    }

    @Column(name = "PAID_AMOUNT", precision = 10)
    public BigDecimal getPaidAmount() {
        return this.paidAmount;
    }

    public void setPaidAmount(BigDecimal paidAmount) {
        this.paidAmount = paidAmount;
    }

    @Column(name = "DISBURSED_AMOUNT", precision = 10)
    public BigDecimal getDisbursedAmount() {
        return this.disbursedAmount;
    }

    public void setDisbursedAmount(BigDecimal disbursedAmount) {
        this.disbursedAmount = disbursedAmount;
    }

    @Column(name = "INTEREST_AMOUNT", precision = 10)
    public BigDecimal getInterestAmount() {
        return this.interestAmount;
    }

    public void setInterestAmount(BigDecimal interestAmount) {
        this.interestAmount = interestAmount;
    }

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "PERIOD_START_DATE", length = 7)
    public Date getPeriodStartDate() {
        return this.periodStartDate;
    }

    public void setPeriodStartDate(Date periodStartDate) {
        this.periodStartDate = periodStartDate;
    }

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "PERIOD_END_DATE", length = 7)
    public Date getPeriodEndDate() {
        return this.periodEndDate;
    }

    public void setPeriodEndDate(Date periodEndDate) {
        this.periodEndDate = periodEndDate;
    }

    @Column(name = "COVERED_DAYS", precision = 5, scale = 0)
    public Integer getCoveredDays() {
        return this.coveredDays;
    }

    public void setCoveredDays(Integer coveredDays) {
        this.coveredDays = coveredDays;
    }

    @Column(name = "PROG_ALLOWABLE_AMT", precision = 10)
    public BigDecimal getProgAllowableAmt() {
        return this.progAllowableAmt;
    }

    public void setProgAllowableAmt(BigDecimal progAllowableAmt) {
        this.progAllowableAmt = progAllowableAmt;
    }

    @Column(name = "BENE_COST_SHARE", precision = 10)
    public BigDecimal getBeneCostShare() {
        return this.beneCostShare;
    }

    public void setBeneCostShare(BigDecimal beneCostShare) {
        this.beneCostShare = beneCostShare;
    }

    @Column(name = "SENT_835_FLAG", length = 1)
    public Character getSent835Flag() {
        return this.sent835Flag;
    }

    public void setSent835Flag(Character sent835Flag) {
        this.sent835Flag = sent835Flag;
    }

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "SENT_835_DATE", length = 7)
    public Date getSent835Date() {
        return this.sent835Date;
    }

    public void setSent835Date(Date sent835Date) {
        this.sent835Date = sent835Date;
    }

    @Column(name = "DRG_CODE_DESC", length = 150)
    public String getDrgCodeDesc() {
        return this.drgCodeDesc;
    }

    public void setDrgCodeDesc(String drgCodeDesc) {
        this.drgCodeDesc = drgCodeDesc;
    }

    @Column(name = "CREATED_BY", nullable = false, length = 30)
    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "DATE_CREATED", nullable = false, length = 7)
    public Date getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    @Column(name = "MODIFIED_BY", length = 30)
    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(String modifiedBy) {
        this.modifiedBy = modifiedBy;
    }

    @Temporal(TemporalType.TIMESTAMP)
    @Column(name = "DATE_MODIFIED", length = 7)
    public Date getDateModified() {
        return this.dateModified;
    }

    public void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }

    @OneToMany(fetch = FetchType.LAZY, mappedBy = "claimReconciliation", cascade = CascadeType.ALL)
    public Set<ClaimProcRecon> getClaimProcRecons() {
        return this.claimProcRecons;
    }

    public void setClaimProcRecons(Set<ClaimProcRecon> claimProcRecons) {
        this.claimProcRecons = claimProcRecons;
    }
}
