package gov.va.med.domain.fee;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

import javax.persistence.*;

/**
 * The persistent class for the CLAIM_OHI_ADJUST database table.
 * 
 */
@Entity(name = "fClaimOhiAdjust")
@Table(name = "CLAIM_OHI_ADJUST")
public class ClaimOhiAdjust implements Serializable {
	private static final long serialVersionUID = 1L;

	private long claimOhiAdjId;
	private ClaimOhi claimOhi;
	private AdjustmentGroup adjustmentGroup;
	private AdjustmentReason adjustmentReason;
	private BigDecimal adjustmentAmount;
	private String quantity;
	private String createdBy;
	private Date dateCreated;

	public ClaimOhiAdjust() {
	}

	public ClaimOhiAdjust(long claimOhiAdjId, ClaimOhi claimOhi, String createdBy, Date dateCreated) {
		super();
		this.claimOhiAdjId = claimOhiAdjId;
		this.claimOhi = claimOhi;
		this.createdBy = createdBy;
		this.dateCreated = dateCreated;
	}

	public ClaimOhiAdjust(long claimOhiAdjId, ClaimOhi claimOhi, AdjustmentGroup adjustmentGroup,
			AdjustmentReason adjustmentReason, BigDecimal adjustmentAmount, String quantity, String createdBy,
			Date dateCreated) {
		super();
		this.claimOhiAdjId = claimOhiAdjId;
		this.claimOhi = claimOhi;
		this.adjustmentGroup = adjustmentGroup;
		this.adjustmentReason = adjustmentReason;
		this.adjustmentAmount = adjustmentAmount;
		this.quantity = quantity;
		this.createdBy = createdBy;
		this.dateCreated = dateCreated;
	}

	@Id
	@GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "f_seq")
	@SequenceGenerator(name = "f_seq", sequenceName = "FPPS_OWNER.MIG")
	@Column(name = "CLAIM_OHI_ADJ_ID", unique = true, nullable = false, precision = 15, scale = 0)
	public long getClaimOhiAdjId() {
		return claimOhiAdjId;
	}

	public void setClaimOhiAdjId(long claimOhiAdjId) {
		this.claimOhiAdjId = claimOhiAdjId;
	}
	
	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name = "CLAIM_OHI_ID", nullable = false)
	public ClaimOhi getClaimOhi() {
		return claimOhi;
	}

	public void setClaimOhi(ClaimOhi claimOhi) {
		this.claimOhi = claimOhi;
	}

	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name = "ADJUSTMENT_GROUP_CD")
	public AdjustmentGroup getAdjustmentGroup() {
		return adjustmentGroup;
	}

	public void setAdjustmentGroup(AdjustmentGroup adjustmentGroup) {
		this.adjustmentGroup = adjustmentGroup;
	}

	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name = "ADJUSTMENT_REASON_CD")
	public AdjustmentReason getAdjustmentReason() {
		return adjustmentReason;
	}

	public void setAdjustmentReason(AdjustmentReason adjustmentReason) {
		this.adjustmentReason = adjustmentReason;
	}

	@Column(name = "ADJUSTMENT_AMOUNT", precision = 10)
	public BigDecimal getAdjustmentAmount() {
		return adjustmentAmount;
	}

	public void setAdjustmentAmount(BigDecimal adjustmentAmount) {
		this.adjustmentAmount = adjustmentAmount;
	}

	@Column(name = "QUANTITY", length = 15)
	public String getQuantity() {
		return quantity;
	}

	public void setQuantity(String quantity) {
		this.quantity = quantity;
	}

	@Column(name = "CREATED_BY", nullable = false, length = 30)
	public String getCreatedBy() {
		return createdBy;
	}

	public void setCreatedBy(String createdBy) {
		this.createdBy = createdBy;
	}

	@Temporal(TemporalType.TIMESTAMP)
	@Column(name = "DATE_CREATED", nullable = false, length = 7)
	public Date getDateCreated() {
		return dateCreated;
	}

	public void setDateCreated(Date dateCreated) {
		this.dateCreated = dateCreated;
	}
}