import { Component, OnInit } from '@angular/core';

@Component({
  selector: 'app-tools',
  templateUrl: './tools.component.html',
  styleUrls: ['./tools.component.scss']
})
export class ToolsComponent implements OnInit {
  public toolsMenuPermissions;
  public userAdministrationPermission;
  public stationMaintenancePermission;
  constructor() {}

  ngOnInit() {
    this.getUserPermissions();
  }

  // Gets the permission from the session, It is used in the html to show and hide things
  getUserPermissions() {
    if (!!sessionStorage.getItem('userInfo')) {
      this.toolsMenuPermissions = JSON.parse(
        sessionStorage.getItem('userInfo')
      )['permissions']['toolsMenu'];

      // setting the user adminstration label if atleast one of the sub links are enabled
      if (
        this.toolsMenuPermissions['createUser'] ||
        this.toolsMenuPermissions['searchModifyUser'] ||
        this.toolsMenuPermissions['createUserRequest'] ||
        this.toolsMenuPermissions['modifyUserRequest'] ||
        this.toolsMenuPermissions['viewUserAccountRequests'] ||
        this.toolsMenuPermissions['privacyRestrictions']
      ) {
        this.userAdministrationPermission = true;
      } else {
        this.userAdministrationPermission = false;
      }

      // setting the station maintenance label if atleast one of the sub links are enabled
      if (
        this.toolsMenuPermissions['addStation'] ||
        this.toolsMenuPermissions['searchStation']
      ) {
        this.stationMaintenancePermission = true;
      } else {
        this.stationMaintenancePermission = false;
      }
    }
  }
}
