import { Component, OnInit } from '@angular/core';
import { ActivatedRoute } from '@angular/router';
import { Location } from '@angular/common';
import { Subscription } from 'rxjs';

import { ColumnMetadata } from '../../../shared/table/cols.model';
import { TableOptions } from '../../../shared/table/table-options.model';
import { VisnService } from './view-visn.service';
import { VisnResponse } from 'app/tools/station-maintenance/view-visn/visn-response.model';

@Component({
  selector: 'app-view-visn',
  templateUrl: './view-visn.component.html',
  providers: [VisnService]
})
export class ViewVisnComponent implements OnInit {
  constructor(
    private visnService: VisnService,
    private activatedRoute: ActivatedRoute,
    public location: Location
  ) {}
  tableOptions = new TableOptions()
    .setNoNumPerPage(true)
    .setNoPagination(true)
    .setNoShowNumResults(true);

  cols: ColumnMetadata[] = [
    new ColumnMetadata('station', 'Station').setAlign('right'),
    new ColumnMetadata('shortName', 'Short Name'),
    new ColumnMetadata('stationName', 'Name'),
    new ColumnMetadata('agedDef', 'Aged Definition').setAlign('right'),
    new ColumnMetadata('parentStation', 'Parent Station').setAlign('right'),
    new ColumnMetadata('allowReroute', 'Allow Rerouting'),
    new ColumnMetadata('createdBy', 'Created by').setAlign('right'),
    new ColumnMetadata('dateCreated', 'Date Created').setDate(true)
  ];
  getVisn: Subscription;
  visnResponse = new VisnResponse();

  ngOnInit() {
    this.getVisn = this.visnService
      .getVisN(this.activatedRoute.snapshot.params.id)
      .subscribe(data => (this.visnResponse = data));
  }
}
