import { Component, OnInit } from '@angular/core';
import { ActivatedRoute } from '@angular/router';
import { Location } from '@angular/common';
import { Subscription } from 'rxjs';

import { ColumnMetadata } from '../../../shared/table/cols.model';
import { TableOptions } from '../../../shared/table/table-options.model';
import { TypeService } from './view-type.service';
import { TypeResponse } from 'app/tools/station-maintenance/view-type/view-type.model';

@Component({
  selector: 'app-view-type',
  templateUrl: './view-type.component.html',
  providers: [TypeService]
})
export class ViewTypeComponent implements OnInit {
  constructor(
    private typeService: TypeService,
    private activatedRoute: ActivatedRoute,
    public location: Location
  ) {}
  tableOptions = new TableOptions()
    .setNoNumPerPage(true)
    .setNoPagination(true)
    .setNoShowNumResults(true);

  cols: ColumnMetadata[] = [
    new ColumnMetadata('station', 'Station').setAlign('right'),
    new ColumnMetadata('shortName', 'Short Name'),
    new ColumnMetadata('stationName', 'Name'),
    new ColumnMetadata('agedDef', 'Aged Definition').setAlign('right'),
    new ColumnMetadata('parentStation', 'Parent Station').setAlign('right'),
    new ColumnMetadata('allowReroute', 'Allow Rerouting'),
    new ColumnMetadata('createdBy', 'Created by').setAlign('right'),
    new ColumnMetadata('dateCreated', 'Date Created').setDate(true)
  ];
  getType: Subscription;
  typeResponse = new TypeResponse();

  ngOnInit() {
    this.getType = this.typeService
      .getType(this.activatedRoute.snapshot.params.id)
      .subscribe(data => {
        this.typeResponse = data;
      });
  }
}
