import { Injectable } from '@angular/core';
import { Observable } from 'rxjs/Observable';
import { Http, Response } from '@angular/http';
import { Subject } from 'rxjs/Subject';
import 'rxjs/add/operator/map';

import { environment } from '../../../../environments/environment';
import { StationInfo } from 'app/tools/models/station-info.model';

@Injectable()
export class ViewStationService {
  constructor(private http: Http) { }

  getStationInfo(id): Observable<StationInfo> {
    return this.http
      .get(`${environment.nodeserver}/tools/viewStation/${id}`)
      .map((response: Response) => response.json());
  }
}
