import { Component, OnInit, OnDestroy } from '@angular/core';
import { ActivatedRoute, Router, Params } from '@angular/router';

import { ColumnMetadata } from '../../../shared/table/cols.model';
import { TableOptions } from '../../../shared/table/table-options.model';
import { StationInfo } from '../../models/station-info.model';
import { ViewStationService } from 'app/tools/station-maintenance/view-station/view-station.service';
import { Subscription } from 'rxjs/Subscription';
import { EditStationService } from '../edit-station/station-edit-maintenance.service';

@Component({
  selector: 'app-view-station',
  templateUrl: './view-station.component.html',
  styleUrls: ['./view-station.component.scss']
})
export class ViewStationComponent implements OnInit, OnDestroy {
  subscription: Subscription;
  saved = false;
  // messages that displays to user once a station has been added or edited.
  statusMessage = '';
  constructor(
    private viewStationService: ViewStationService,
    private editStationService: EditStationService,
    private activatedRoute: ActivatedRoute,
    private router: Router
  ) {
    this.subscription = this.editStationService.notify.subscribe(status => {
      this.statusMessage = status.message;
      this.saved = status.boolean;
    });
  }

  tableOptions = new TableOptions()
    .setNoNumPerPage(true)
    .setNoPagination(true)
    .setNoShowNumResults(true)
    .setAfterLoad(function(items) {
      items.forEach(station => {
        station.modifyButton = 'Modify';
      });
    });

  contactInfoCols: ColumnMetadata[] = [
    new ColumnMetadata('contactName', 'Contact Name'),
    new ColumnMetadata('contactType', 'Contact Type'),
    new ColumnMetadata('address1', 'Address 1'),
    new ColumnMetadata('address2', 'Address 2'),
    new ColumnMetadata('city', 'City'),
    new ColumnMetadata('zip', 'ZIP Code').setAlign('right'),
    new ColumnMetadata('email', 'Email'),
    new ColumnMetadata('fax', 'Fax').setAlign('right'),
    new ColumnMetadata('phone', 'Phone').setAlign('right'),
    new ColumnMetadata('createdBy', 'Created By'),
    new ColumnMetadata('dateCreated', 'Date Created')
      .setDate(true)
      .setAlign('right')
  ];

  zipCodeCols: ColumnMetadata[] = [
    new ColumnMetadata('zip_code', 'ZIP Code').setAlign('right'),
    new ColumnMetadata('active', 'Active Flag'),
    new ColumnMetadata('fips_county_code', 'FIPS Country Code').setAlign(
      'right'
    ),
    new ColumnMetadata('urban_indicator', 'Urban Indicator').setAlign('right'),
    new ColumnMetadata('created_by', 'Created By'),
    new ColumnMetadata('date_created', 'Date Created')
      .setDate(true)
      .setAlign('right'),
    new ColumnMetadata('modifyButton', 'Modify')
      .setButton(true)
      .setSort(false)
      .setAlign('center')
  ];
  getStation: Subscription;
  stationInfo: StationInfo = new StationInfo();

  ngOnInit() {
    this.activatedRoute.params.subscribe((param: Params) => {
      this.getStation = this.viewStationService
        .getStationInfo(param['id'])
        .subscribe(data => {
          this.stationInfo = data;
          console.log('view-Station ', data);
        });
    });
  }

  onEdit() {
    this.editStationService.setCurrentStation(this.stationInfo.station);
    this.router.navigate(['stationMaintanceEdit']);
  }

  onDone() {
    this.router.navigate(['searchStation']);
  }

  ngOnDestroy() {
    this.getStation.unsubscribe();
    this.subscription.unsubscribe();
  }
}
