import { Observable } from 'rxjs/Observable';
import { StationMaintenanceAddZipCodeService } from '../addZipCode/station-maintenance-add-zip-code.service';
import { ViewStationService } from './view-station.service';
import { FormBuilder } from '@angular/forms';
import 'rxjs/add/observable/from';
import { ViewStationComponent, EditStationService } from 'app/tools';
import { ActivatedRoute, ActivatedRouteSnapshot } from '@angular/router';

describe('StationEditComponent', () => {
  let viewStationService: ViewStationService;
  let editStationService: EditStationService;
  let component: ViewStationComponent;
  let activatedRoute: ActivatedRoute;
  beforeEach(() => {
    activatedRoute = new ActivatedRoute();
    activatedRoute.snapshot = new ActivatedRouteSnapshot();
    activatedRoute.snapshot.params = { id: 1 };
    viewStationService = new ViewStationService(null);
    editStationService = new EditStationService(null);
    component = new ViewStationComponent(
      viewStationService,
      editStationService,
      activatedRoute,
      null
    );
  });
  it('should get stationInfo from service', () => {
    const station = {
      station: '1',
      shortName: '2',
      stationName: '3',
      stationType: '4',
      visnNumber: '5',
      allowReroute: false,
      agedDef: '6',
      parentStation: '7',
      createdBy: '8',
      dateCreated: '9',
      contactInfoRequest: [],
      zipcodes: []
    };
    spyOn(viewStationService, 'getStationInfo').and.callFake(() => {
      return new Observable(observer => observer.next(station));
    });
    component.ngOnInit();
    expect(component.stationInfo).toBe(station);
  });
});
