import {
  AfterViewInit,
  Component,
  ViewChild,
  OnInit,
  OnDestroy
} from '@angular/core';
import { NgForm } from '@angular/forms';
import { Router } from '@angular/router';

import { RestService } from '../../../shared/service/rest.service';
import { ColumnMetadata } from '../../../shared/table/cols.model';
import { TableOptions } from '../../../shared/table/table-options.model';
import { TableComponent } from '../../../shared/table/table.component';
import { StationSearch } from '../../models/search-station.model';
import { EditStationService } from '../edit-station/station-edit-maintenance.service';
import { Subscription } from 'rxjs/Subscription';

@Component({
  selector: 'app-search-station',
  templateUrl: 'search-station.component.html'
})
export class SearchStationComponent implements AfterViewInit, OnInit {
  stationSearch: StationSearch = new StationSearch();
  message: String = '';
  results = [];
  deleted = false;
  deletedMessage = '';
  // toggle boolean to show successful message if user deletes a station.
  subscription: Subscription;
  // end of comment

  @ViewChild(TableComponent) tableComponent: TableComponent;
  tableOptions = new TableOptions().setAfterLoad(function(items) {
    items.forEach(station => {
      station.edit = 'Modify';
      station.stationLink = '/viewStation/' + station.station;
      station.visnNumber = parseInt(station.visnNumber, 10);
    });
  });

  cols: ColumnMetadata[] = [
    new ColumnMetadata('station', 'Station').setAlign('right'),
    new ColumnMetadata('shortName', 'Short Name'),
    new ColumnMetadata('stationName', 'Name'),
    new ColumnMetadata('stationType', 'Type'),
    new ColumnMetadata('visnNumber', 'VISN').setAlign('right'),
    new ColumnMetadata('allowReroute', 'Allow Reroute'),
    new ColumnMetadata('agedDef', 'Aged Def').setAlign('right'),
    new ColumnMetadata('parentStation', 'Parent Station').setAlign('right'),
    new ColumnMetadata('createdBy', 'Created by'),
    new ColumnMetadata('dateCreated', 'Date Created')
      .setDate(true)
      .setAlign('right'),
    new ColumnMetadata('edit', '')
      .setButton(true)
      .setSort(false)
      .setAlign('center')
  ];

  constructor(
    public router: Router,
    public editStationService: EditStationService
  ) {
    this.subscription = this.editStationService.notify.subscribe(status => {
      this.deletedMessage = status.message;
      this.deleted = status.boolean;
    });
  }
  ngOnInit() {}

  ngAfterViewInit() {
    this.onSubmit();
  }

  onSubmit() {
    this.tableComponent.update();
  }
  clear() {
    this.stationSearch.shortName = '';
    this.stationSearch.station = '';
    this.stationSearch.stationName = '';
    this.onSubmit();
  }
  getParams() {
    return Object.assign(this.stationSearch, {
      userName: sessionStorage.getItem('userName'),
      userRole: 'ADMIN'
    });
  }
  onModify(event) {
    this.editStationService.setCurrentStation(event.item.station);
    this.router.navigate(['stationMaintanceEdit']);
  }

  onDone() {
    this.router.navigate['searchStation'];
  }

  ngOnDestroy() {
    this.subscription.unsubscribe();
  }
}
