import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { SearchStationComponent } from './search-station.component';
import { MenuComponent } from '../../../shared/menu/menu.component';
import { RouterTestingModule } from '@angular/router/testing';
import { FormsModule } from '@angular/forms';
import { HttpModule } from '@angular/http';
import { RestService } from '../../../shared/service/rest.service';
import { WindowRefService } from '../../../window-ref.service';
import { TableComponent } from '../../../shared/table/table.component';
import { StationSearch } from '../../models/search-station.model';
import { EditStationService } from '../edit-station/station-edit-maintenance.service';
import { AppModule } from '../../../app.module';
import { APP_BASE_HREF } from '@angular/common';

describe('SearchStationComponent', () => {
  let component: SearchStationComponent;
  let fixture: ComponentFixture<SearchStationComponent>;

  beforeEach(
    async(() => {
      TestBed.configureTestingModule({
        imports: [FormsModule, HttpModule, RouterTestingModule, AppModule],
        declarations: [],
        providers: [
          WindowRefService,
          EditStationService,
          { provide: APP_BASE_HREF, useValue: '/' }
        ]
      }).compileComponents();
    })
  );

  beforeEach(() => {
    fixture = TestBed.createComponent(SearchStationComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should be created', () => {
    expect(component).toBeTruthy();
  });
  it('should clear search parameters', () => {
    component.stationSearch.shortName = 'Hi';
    component.stationSearch.station = 'Hi';
    component.stationSearch.stationName = 'Hi';
    component.clear();
    expect(component.stationSearch.shortName).toEqual('');
    expect(component.stationSearch.station).toEqual('');
    expect(component.stationSearch.stationName).toEqual('');
  });
  it('should be concatenate search parameters with login data', () => {
    component.stationSearch.shortName = 'Hi';
    component.stationSearch.station = 'Hi';
    component.stationSearch.stationName = 'Hi';
    sessionStorage.setItem('userName', 'Jimmy');
    sessionStorage.setItem('userRole', 'ADMIN');
    const params = component.getParams();
    expect(params.shortName).toEqual('Hi');
    expect(params.stationName).toEqual('Hi');
    expect(params.userName).toEqual('Jimmy');
    expect(params.userRole).toEqual('ADMIN');
  });
});
